/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.GuiButtonPage;
import net.ilexiconn.llibrary.client.gui.GuiButtonSurvivalTab;
import net.ilexiconn.llibrary.client.gui.GuiHelper;
import net.ilexiconn.llibrary.client.gui.GuiOverride;
import net.ilexiconn.llibrary.client.render.entity.RenderLLibraryPlayer;
import net.ilexiconn.llibrary.client.screenshot.ScreenshotHelper;
import net.ilexiconn.llibrary.client.toast.Toast;
import net.ilexiconn.llibrary.common.block.IHighlightedBlock;
import net.ilexiconn.llibrary.common.config.LLibraryConfigHandler;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.ilexiconn.llibrary.common.survivaltab.SurvivalTab;
import net.ilexiconn.llibrary.common.update.VersionHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    private static final double timeU = 5.0E7;
    public static KeyBinding screenshotKeyBinding;
    private RenderPlayer prevRenderPlayer;
    private Minecraft mc = Minecraft.func_71410_x();
    private long initialTime = System.nanoTime();
    private double deltaU = 0.0;
    private long timer = System.currentTimeMillis();

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Specials.Post event) {
        if (event.entityPlayer == this.mc.field_71439_g && this.prevRenderPlayer != null) {
            this.mc.func_175598_ae().field_78729_o.put(event.entityPlayer.getClass(), this.prevRenderPlayer);
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        Render entityRenderObject;
        EntityPlayer player = event.entityPlayer;
        if (this.mc.field_71439_g == player && !((entityRenderObject = this.mc.func_175598_ae().func_78713_a((Entity)event.entityPlayer)) instanceof RenderLLibraryPlayer)) {
            this.prevRenderPlayer = (RenderPlayer)entityRenderObject;
            this.mc.func_175598_ae().field_78729_o.put(player.getClass(), ClientProxy.renderCustomPlayer);
        }
    }

    @SubscribeEvent
    public void onBlockHighlight(DrawBlockHighlightEvent event) {
        BlockPos blockPos;
        Block block;
        if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = event.player.field_70170_p.func_180495_p(blockPos = event.target.func_178782_a()).func_177230_c()) instanceof IHighlightedBlock) {
            List<AxisAlignedBB> bounds = ((IHighlightedBlock)block).getHighlightedBoxes(event.player.field_70170_p, blockPos, event.player.field_70170_p.func_180495_p(blockPos), event.player);
            BlockPos pos = event.player.func_180425_c();
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            for (AxisAlignedBB box : bounds) {
                RenderGlobal.func_181561_a((AxisAlignedBB)box.func_72317_d((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()).func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p())));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        if (SurvivalTab.getSurvivalTabList().size() > 0) {
            int count = 2;
            for (SurvivalTab survivalTab : SurvivalTab.getSurvivalTabList()) {
                if (survivalTab.getContainer() == null || !survivalTab.getContainer().isInstance(event.gui)) continue;
                for (SurvivalTab tab : SurvivalTab.getSurvivalTabList()) {
                    if (tab.getPage() == SurvivalTab.getCurrentPage()) {
                        event.buttonList.add(new GuiButtonSurvivalTab(count, tab));
                    }
                    ++count;
                }
            }
            if (count > 11) {
                GuiContainer container = (GuiContainer)event.gui;
                event.buttonList.add(new GuiButtonPage(-1, container.field_147003_i, container.field_147009_r - 50, event.gui));
                event.buttonList.add(new GuiButtonPage(-2, container.field_147003_i + container.field_146999_f - 20, container.field_147009_r - 50, event.gui));
            }
        }
        if (event.gui instanceof GuiMainMenu) {
            for (JsonModUpdate mod : VersionHandler.getOutdatedMods()) {
                if (mod.updated) continue;
                Toast.makeText("Update available!", mod.name, mod.currentVersion + " -> " + mod.getUpdateVersion().getVersionString()).show();
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (LLibraryConfigHandler.threadedScreenshots && screenshotKeyBinding.func_151468_f()) {
            ScreenshotHelper.takeScreenshot();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : GuiHelper.getOverrides().entrySet()) {
            if (event.gui == null || event.gui.getClass() != e.getValue()) continue;
            GuiOverride gui = e.getKey();
            long currentTime = System.nanoTime();
            this.deltaU += (double)(currentTime - this.initialTime) / 5.0E7;
            this.initialTime = currentTime;
            gui.field_146294_l = event.gui.field_146294_l;
            gui.field_146295_m = event.gui.field_146295_m;
            gui.overriddenScreen = event.gui;
            if (this.deltaU >= 1.0) {
                gui.func_73876_c();
                this.deltaU -= 1.0;
            }
            if (System.currentTimeMillis() - this.timer > 1000L) {
                this.timer += 1000L;
            }
            gui.func_73863_a(event.mouseX, event.mouseY, event.renderPartialTicks);
            if (gui.field_146292_n.isEmpty()) continue;
            for (GuiButton button : gui.field_146292_n) {
                for (int i = 0; i < event.gui.field_146292_n.size(); ++i) {
                    GuiButton button1 = (GuiButton)event.gui.field_146292_n.get(i);
                    if (button.field_146127_k != button1.field_146127_k) continue;
                    event.gui.field_146292_n.remove(button1);
                }
            }
            event.gui.field_146292_n.addAll(gui.field_146292_n);
        }
        for (Toast toast : Toast.getToastList()) {
            toast.getGui().drawToast();
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        for (Toast toast : Toast.getToastList()) {
            toast.getGui().drawToast();
        }
    }

    @SubscribeEvent
    public void onButtonPress(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : GuiHelper.getOverrides().entrySet()) {
            if (event.gui.getClass() != e.getValue()) continue;
            e.getKey().func_146284_a(event.button);
        }
    }

    @SubscribeEvent
    public void onInitGui(GuiScreenEvent.InitGuiEvent.Pre event) {
        for (Map.Entry<GuiOverride, Class<? extends GuiScreen>> e : GuiHelper.getOverrides().entrySet()) {
            if (event.gui.getClass() != e.getValue()) continue;
            e.getKey().func_146280_a(this.mc, event.gui.field_146294_l, event.gui.field_146295_m);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Iterator<Toast> iterator = Toast.getToastList().iterator();
            while (iterator.hasNext()) {
                Toast toast = iterator.next();
                if (toast.tick() > 0) continue;
                iterator.remove();
            }
        }
    }
}

