/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.ilexiconn.llibrary.client.gui.GuiModUpdateList;
import net.ilexiconn.llibrary.common.config.JsonConfigHelper;
import net.ilexiconn.llibrary.common.json.JsonFactory;
import net.ilexiconn.llibrary.common.json.container.JsonModUpdate;
import net.ilexiconn.llibrary.common.json.container.JsonUpdateEntry;
import net.ilexiconn.llibrary.common.update.ChangelogHandler;
import net.ilexiconn.llibrary.common.update.VersionHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiModUpdates
extends GuiScreen {
    private GuiScreen mainMenu;
    private GuiModUpdateList modList;
    private GuiScrollingList modInfo;
    private int selected = -1;
    private JsonModUpdate selectedMod;
    private int listWidth;
    private ArrayList<JsonModUpdate> mods;
    private GuiButton buttonUpdate;
    private GuiButton buttonDone;
    private int numButtons = SortType.values().length;
    private String lastFilterText = "";
    private GuiTextField search;
    private boolean sorted = false;
    private SortType sortType = SortType.NORMAL;

    public GuiModUpdates(GuiScreen mainMenu) {
        this.mainMenu = mainMenu;
        this.mods = new ArrayList();
        this.mods.addAll(VersionHandler.getOutdatedMods());
    }

    public void func_73866_w_() {
        for (JsonModUpdate mod : this.mods) {
            this.listWidth = Math.max(this.listWidth, this.field_146289_q.func_78256_a(mod.name) + 47);
            this.listWidth = Math.max(this.listWidth, this.field_146289_q.func_78256_a(mod.currentVersion) + 47);
            this.listWidth = Math.max(this.listWidth, this.field_146289_q.func_78256_a(org.apache.commons.lang3.StringUtils.capitalize((String)mod.updateType.name().toLowerCase())) + 47);
        }
        this.listWidth = Math.min(this.listWidth, 150);
        this.modList = new GuiModUpdateList(this, this.mods, this.listWidth);
        this.buttonDone = new GuiButton(6, (this.modList.getRight() + this.field_146294_l) / 2 - 100, this.field_146295_m - 38, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        this.buttonUpdate = new GuiButton(20, 10, this.field_146295_m - 38, this.listWidth, 20, "Update");
        this.field_146292_n.add(this.buttonUpdate);
        this.search = new GuiTextField(0, this.field_146289_q, 12, this.modList.getBottom() + 17, this.modList.getListWidth() - 4, 14);
        this.search.func_146195_b(true);
        this.search.func_146205_d(true);
        int width = this.modList.getListWidth() / this.numButtons;
        int x = 10;
        int y = 10;
        int buttonMargin = 1;
        GuiButton normalSort = new GuiButton(SortType.NORMAL.buttonID, x, y, width - buttonMargin, 20, I18n.func_135052_a((String)"fml.menu.mods.normal", (Object[])new Object[0]));
        normalSort.field_146124_l = false;
        this.field_146292_n.add(normalSort);
        this.field_146292_n.add(new GuiButton(SortType.A_TO_Z.buttonID, x += width + buttonMargin, y, width - buttonMargin, 20, "A-Z"));
        this.field_146292_n.add(new GuiButton(SortType.Z_TO_A.buttonID, x += width + buttonMargin, y, width - buttonMargin, 20, "Z-A"));
        this.updateCache();
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        this.search.func_146192_a(x, y, button);
        if (button == 1 && x >= this.search.field_146209_f && x < this.search.field_146209_f + this.search.field_146218_h && y >= this.search.field_146210_g && y < this.search.field_146210_g + this.search.field_146219_i) {
            this.search.func_146180_a("");
        }
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        super.func_73869_a(c, keyCode);
        this.search.func_146201_a(c, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastFilterText)) {
            this.reloadMods();
            this.sorted = false;
        }
        if (!this.sorted) {
            this.reloadMods();
            Collections.sort(this.mods, this.sortType);
            this.selected = this.mods.indexOf(this.selectedMod);
            this.modList.setSelected(this.mods.indexOf(this.selectedMod));
            this.sorted = true;
        }
    }

    private void reloadMods() {
        ArrayList<JsonModUpdate> mods = this.modList.getMods();
        mods.clear();
        for (JsonModUpdate m : VersionHandler.getOutdatedMods()) {
            if (!m.name.toLowerCase().contains(this.search.func_146179_b().toLowerCase())) continue;
            mods.add(m);
        }
        this.mods = mods;
        this.lastFilterText = this.search.func_146179_b();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            SortType type = SortType.getTypeForButton(button);
            if (type != null) {
                for (GuiButton b : this.field_146292_n) {
                    if (SortType.getTypeForButton(b) == null) continue;
                    b.field_146124_l = true;
                }
                button.field_146124_l = false;
                this.sorted = false;
                this.sortType = type;
                this.mods = this.modList.getMods();
            } else {
                switch (button.field_146127_k) {
                    case 6: {
                        this.field_146297_k.func_147108_a(this.mainMenu);
                        return;
                    }
                    case 20: {
                        Desktop desktop;
                        if (this.selectedMod.getDirectUpdateUrl() != null) {
                            List updateQueue;
                            File modfile = this.selectedMod.modContainer.getSource();
                            File configFile = new File("updatequeue.json");
                            if (!configFile.exists()) {
                                updateQueue = Lists.newArrayList();
                            } else {
                                try {
                                    updateQueue = (List)JsonFactory.getGson().fromJson((Reader)new FileReader(configFile), new TypeToken<List<JsonModUpdate>>(){}.getType());
                                }
                                catch (FileNotFoundException e) {
                                    e.printStackTrace();
                                    return;
                                }
                            }
                            updateQueue.add(new JsonUpdateEntry(this.selectedMod.getDirectUpdateUrl(), this.selectedMod.modid, this.selectedMod.name, modfile.getName(), this.selectedMod.getUpdateVersion().getVersionString()));
                            JsonConfigHelper.saveConfig(updateQueue, configFile);
                            this.selectedMod.updated = true;
                            this.buttonUpdate.field_146124_l = false;
                            this.buttonUpdate.field_146126_j = "Restart to apply";
                            break;
                        }
                        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                        if (desktop == null || !desktop.isSupported(Desktop.Action.BROWSE)) break;
                        try {
                            desktop.browse(new URI(this.selectedMod.getUpdateUrl()));
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        super.func_146284_a(button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (VersionHandler.getOutdatedMods().isEmpty()) {
            this.func_146276_q_();
            int i = this.field_146294_l / 2;
            int j = this.field_146295_m / 2;
            this.buttonDone.field_146128_h = this.field_146294_l / 2 - 100;
            this.buttonDone.field_146129_i = this.field_146295_m - 38;
            this.field_146292_n.clear();
            this.field_146292_n.add(this.buttonDone);
            this.drawScaledString(I18n.func_135052_a((String)"gui.llibrary.updatecheck.no_updates.line1", (Object[])new Object[0]), i, j - 40, 0xFFFFFF, 2.0f);
            this.drawScaledString(I18n.func_135052_a((String)"gui.llibrary.updatecheck.no_updates.line2", (Object[])new Object[0]), i, j - 20, 0xFFFFFF, 1.0f);
        } else {
            this.modList.drawScreen(mouseX, mouseY, partialTicks);
            if (this.modInfo != null) {
                this.modInfo.drawScreen(mouseX, mouseY, partialTicks);
            }
            int left = (this.field_146294_l - this.listWidth - 38) / 2 + this.listWidth + 30;
            this.func_73732_a(this.field_146289_q, "Mod Updates", left, 16, 0xFFFFFF);
            String text = I18n.func_135052_a((String)"fml.menu.mods.search", (Object[])new Object[0]);
            int x = (10 + this.modList.getRight()) / 2 - this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, x, this.modList.getBottom() + 5, 0xFFFFFF);
            this.search.func_146194_f();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void selectModIndex(int index) {
        if (index == this.selected) {
            return;
        }
        this.selected = index;
        this.selectedMod = index >= 0 && index <= this.mods.size() ? this.mods.get(this.selected) : null;
        this.updateCache();
    }

    public boolean modIndexSelected(int index) {
        return index == this.selected;
    }

    private void updateCache() {
        this.buttonUpdate.field_146125_m = false;
        this.modInfo = null;
        if (this.selectedMod == null) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        this.buttonUpdate.field_146125_m = true;
        if (this.selectedMod.updated) {
            this.buttonUpdate.field_146124_l = false;
            this.buttonUpdate.field_146126_j = "Restart to apply";
        } else {
            this.buttonUpdate.field_146124_l = true;
            this.buttonUpdate.field_146126_j = "Update";
        }
        lines.add(this.selectedMod.name);
        lines.add(String.format("Current version: %s", this.selectedMod.currentVersion));
        lines.add(String.format("Newest version: %s (%s)", this.selectedMod.getUpdateVersion().getVersionString(), this.selectedMod.updateType.name()));
        lines.add(null);
        Collections.addAll(lines, ChangelogHandler.getChangelog(this.selectedMod, this.selectedMod.getUpdateVersion()));
        this.modInfo = new Info(this.field_146294_l - this.listWidth - 30, lines);
    }

    public void drawScaledString(String text, int x, int y, int color, float scale) {
        GL11.glPushMatrix();
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        this.func_73732_a(this.field_146289_q, text, (int)((float)x / scale), (int)((float)y / scale), color);
        GL11.glPopMatrix();
    }

    private static enum SortType implements Comparator<JsonModUpdate>
    {
        NORMAL(24),
        A_TO_Z(25){

            @Override
            protected int compare(String name1, String name2) {
                return name1.compareTo(name2);
            }
        }
        ,
        Z_TO_A(26){

            @Override
            protected int compare(String name1, String name2) {
                return name2.compareTo(name1);
            }
        };

        private int buttonID;

        private SortType(int buttonID) {
            this.buttonID = buttonID;
        }

        public static SortType getTypeForButton(GuiButton button) {
            for (SortType t : SortType.values()) {
                if (t.buttonID != button.field_146127_k) continue;
                return t;
            }
            return null;
        }

        @Override
        protected int compare(String name1, String name2) {
            return 0;
        }

        @Override
        public int compare(JsonModUpdate o1, JsonModUpdate o2) {
            String name1 = StringUtils.func_76338_a((String)o1.name).toLowerCase();
            String name2 = StringUtils.func_76338_a((String)o2.name).toLowerCase();
            return this.compare(name1, name2);
        }
    }

    private class Info
    extends GuiScrollingList {
        private List<IChatComponent> lines;

        public Info(int width, List<String> lines) {
            super(GuiModUpdates.this.field_146297_k, width, GuiModUpdates.this.field_146295_m, 32, GuiModUpdates.this.field_146295_m - 77 + 4, GuiModUpdates.this.listWidth + 20, 60, GuiModUpdates.this.field_146294_l, GuiModUpdates.this.field_146295_m);
            this.lines = null;
            this.lines = this.resizeContent(lines);
            this.setHeaderInfo(true, this.getHeaderHeight());
        }

        protected int getSize() {
            return 0;
        }

        protected void elementClicked(int index, boolean doubleClick) {
        }

        protected boolean isSelected(int index) {
            return false;
        }

        protected void drawBackground() {
        }

        protected void drawSlot(int slotIdx, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        }

        private List<IChatComponent> resizeContent(List<String> lines) {
            ArrayList<IChatComponent> ret = new ArrayList<IChatComponent>();
            for (String line : lines) {
                if (line == null) {
                    ret.add(null);
                    continue;
                }
                IChatComponent chat = ForgeHooks.newChatWithLinks((String)line, (boolean)false);
                ret.addAll(GuiUtilRenderComponents.func_178908_a((IChatComponent)chat, (int)(this.listWidth - 8), (FontRenderer)GuiModUpdates.this.field_146289_q, (boolean)false, (boolean)true));
            }
            return ret;
        }

        private int getHeaderHeight() {
            int height = this.lines.size() * 10;
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            return height;
        }

        protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
            int top = relativeY;
            for (IChatComponent line : this.lines) {
                if (line != null) {
                    GlStateManager.func_179147_l();
                    GuiModUpdates.this.field_146289_q.func_175063_a(line.func_150254_d(), (float)(this.left + 4), (float)top, 0xFFFFFF);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                top += 10;
            }
        }

        protected void clickHeader(int x, int y) {
            if (y <= 0) {
                return;
            }
            int lineIdx = y / 10;
            if (lineIdx >= this.lines.size()) {
                return;
            }
            IChatComponent line = this.lines.get(lineIdx);
            if (line != null) {
                int k = -4;
                for (IChatComponent part : line) {
                    if (!(part instanceof ChatComponentText) || (k += GuiModUpdates.this.field_146289_q.func_78256_a(((ChatComponentText)part).func_150265_g())) < x) continue;
                    GuiModUpdates.this.func_175276_a(part);
                    break;
                }
            }
        }
    }
}

