/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.toast;

import com.google.common.collect.Lists;
import java.util.List;
import net.ilexiconn.llibrary.client.gui.GuiToast;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Toast {
    private static List<Toast> toastList = Lists.newArrayList();
    private GuiToast gui;
    private int posX;
    private int posY;
    private int duration;
    private int lastDuration;

    private Toast(int x, int y, int d) {
        this.posX = x;
        this.posY = y;
        this.duration = d;
        this.lastDuration = d;
    }

    public static Toast makeText(String ... text) {
        Toast toast = new Toast(10, 10, 60);
        int stringWidth = 0;
        for (String s : text) {
            stringWidth = Math.max(stringWidth, Minecraft.func_71410_x().field_71466_p.func_78256_a(s));
        }
        toast.gui = new GuiToast(toast, stringWidth + 10, text);
        return toast;
    }

    public Toast setPosition(int x, int y) {
        this.posX = x;
        this.posY = y;
        return this;
    }

    public Toast setDuration(int d) {
        this.duration = d;
        this.lastDuration = d;
        return this;
    }

    public Toast show() {
        this.duration = this.lastDuration;
        toastList.add(this);
        return this;
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public int getDuration() {
        return this.duration;
    }

    @Deprecated
    public static List<Toast> getToastList() {
        return toastList;
    }

    @Deprecated
    public int tick() {
        return this.duration--;
    }

    @Deprecated
    public GuiToast getGui() {
        return this.gui;
    }
}

