/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.command.builder;

import java.util.List;
import net.ilexiconn.llibrary.common.command.builder.Argument;
import net.ilexiconn.llibrary.common.command.builder.ArgumentType;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class CommandArguments {
    private List<Argument> arguments;
    private ICommandSender commandSender;

    public CommandArguments(List<Argument> arguments, ICommandSender commandSender) {
        this.arguments = arguments;
        this.commandSender = commandSender;
    }

    public boolean has(String name) {
        for (Argument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public <T> T get(String name) {
        for (Argument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            try {
                return (T)argument.getType().parse(this.commandSender, argument.getValue());
            }
            catch (CommandException e) {
                this.commandSender.func_145747_a(new ChatComponentText(e.getLocalizedMessage()).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
            }
        }
        return null;
    }

    public ArgumentType<?> type(String name) {
        for (Argument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument.getType();
        }
        return null;
    }

    public String asString(String name) {
        return (String)this.get(name);
    }

    public int asInt(String name) {
        return (Integer)this.get(name);
    }

    public EntityPlayer asPlayer(String name) {
        return (EntityPlayer)this.get(name);
    }

    public ItemStack asStack(String name) {
        return (ItemStack)this.get(name);
    }

    public boolean asBoolean(String name) {
        return (Boolean)this.get(name);
    }
}

