/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.message;

import io.netty.buffer.ByteBuf;
import net.ilexiconn.llibrary.common.animation.IAnimated;
import net.ilexiconn.llibrary.common.message.AbstractMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageLLibraryAnimationAction
extends AbstractMessage<MessageLLibraryAnimationAction> {
    public int animationId;
    public int entityId;
    public int activationTick;

    public MessageLLibraryAnimationAction() {
    }

    public MessageLLibraryAnimationAction(int animation, int entity, int tick) {
        this.animationId = animation;
        this.entityId = entity;
        this.activationTick = tick;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientMessage(MessageLLibraryAnimationAction message, EntityPlayer player) {
        Entity entity = player.field_70170_p.func_73045_a(message.entityId);
        IAnimated animated = (IAnimated)entity;
        if (entity != null && message.animationId != 0) {
            animated.getAnimation().actions.get(message.activationTick).execute(message.animationId, entity);
        }
    }

    @Override
    public void handleServerMessage(MessageLLibraryAnimationAction message, EntityPlayer player) {
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.animationId);
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.activationTick);
    }

    public void fromBytes(ByteBuf buffer) {
        this.animationId = buffer.readInt();
        this.entityId = buffer.readInt();
        this.activationTick = buffer.readInt();
    }
}

