/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.nbt;

import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NbtHelper {
    public static void writeInventoryToNbt(NBTTagCompound compound, IInventory inventory) {
        NBTTagList items = new NBTTagList();
        for (byte slot = 0; slot < inventory.func_70302_i_(); slot = (byte)((byte)(slot + 1))) {
            ItemStack stack = inventory.func_70301_a((int)slot);
            if (stack == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("slot", slot);
            stack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("inventory", (NBTBase)items);
    }

    public static void readInventoryFromNbt(NBTTagCompound compound, IInventory inventory) {
        NBTTagList items = compound.func_150295_c("inventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("slot");
            inventory.func_70299_a((int)slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    public static void writeStackToNbt(NBTTagCompound nbtTag, String name, ItemStack stack) {
        nbtTag.func_74782_a(name, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
    }

    public static ItemStack readStackFromNbt(NBTTagCompound nbtTag, String name) {
        return ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l(name));
    }

    public static Object getValueFromNbtTag(NBTBase type) {
        if (type instanceof NBTTagByte) {
            return ((NBTTagByte)type).func_150290_f();
        }
        if (type instanceof NBTTagShort) {
            return ((NBTTagShort)type).func_150289_e();
        }
        if (type instanceof NBTTagInt) {
            return ((NBTTagInt)type).func_150287_d();
        }
        if (type instanceof NBTTagLong) {
            return ((NBTTagLong)type).func_150291_c();
        }
        if (type instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)type).func_150288_h());
        }
        if (type instanceof NBTTagDouble) {
            return ((NBTTagDouble)type).func_150286_g();
        }
        if (type instanceof NBTTagString) {
            return type.toString();
        }
        if (type instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)type).func_150292_c();
        }
        if (type instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)type).func_150302_c();
        }
        return null;
    }

    public static NBTBase getNbtTagFromValue(Object value) {
        if (value instanceof Boolean) {
            return new NBTTagByte((Boolean)value != false ? (byte)1 : 0);
        }
        if (value instanceof Byte) {
            return new NBTTagByte(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new NBTTagShort(((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return new NBTTagInt(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new NBTTagLong(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
        if (value instanceof String) {
            return new NBTTagString((String)value);
        }
        if (value instanceof byte[]) {
            return new NBTTagByteArray((byte[])value);
        }
        if (value instanceof int[]) {
            return new NBTTagIntArray((int[])value);
        }
        return null;
    }
}

