/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.time;

import java.util.Calendar;
import net.ilexiconn.llibrary.common.time.Time;

public class SystemTime {
    private static String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static String[] weekDayNames = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
    private static Calendar c = Calendar.getInstance();

    public static int getYear() {
        return c.get(1);
    }

    public static int getMonth() {
        return c.get(2) + 1;
    }

    public static int getWeekOfMonth() {
        return c.get(4);
    }

    public static int getWeekOfYear() {
        return c.get(3);
    }

    public static int getDayOfMonth() {
        return c.get(5);
    }

    public static int getDayOfWeek() {
        int i = c.get(7);
        return i == 1 ? 7 : i - 1;
    }

    public static int getDayOfWeek(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        int i = cal.get(7);
        return i == 1 ? 7 : i - 1;
    }

    public static int getDayOfWeek(int month, int day) {
        return SystemTime.getDayOfWeek(SystemTime.getYear(), month, day);
    }

    public static int getDayOfWeek(int year, String month, int day) {
        return SystemTime.getDayOfWeek(year, SystemTime.getMonthFromName(month), day);
    }

    public static int getDayOfYear() {
        return c.get(6);
    }

    public static int getHourOfDay() {
        return c.get(11);
    }

    public static int getMinuteOfHour() {
        return c.get(12);
    }

    public static int getSecondOfMinute() {
        return c.get(13);
    }

    public static Time getTime() {
        Time time = new Time();
        time.hours = SystemTime.getHourOfDay();
        time.minutes = SystemTime.getMinuteOfHour();
        time.seconds = SystemTime.getSecondOfMinute();
        return time;
    }

    public static String getMonthName(int month) {
        return month > 0 && month < 13 ? monthNames[month - 1] : "missingno";
    }

    public static int getMonthFromName(String month) {
        for (int i = 0; i < monthNames.length; ++i) {
            if (!monthNames[i].equals(month)) continue;
            return i + 1;
        }
        return 0;
    }

    public static String getDayOfWeekName(int dayOfWeek) {
        return dayOfWeek > 0 && dayOfWeek < 8 ? weekDayNames[dayOfWeek - 1] : "missingno";
    }

    public static int getDayOfWeekFromName(String dayOfWeek) {
        for (int i = 0; i < weekDayNames.length; ++i) {
            if (!weekDayNames[i].equals(dayOfWeek)) continue;
            return i + 1;
        }
        return 0;
    }

    public static String getNumberSuffix(int number) {
        String s = String.valueOf(number);
        if (s.endsWith("1")) {
            return "st";
        }
        if (s.endsWith("2")) {
            return "nd";
        }
        if (s.endsWith("3")) {
            return "rd";
        }
        return "th";
    }
}

