/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.common.world.gen;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.biome.BiomeGenBase;

public abstract class WorldHeightmapGenerator {
    public byte[][] heightmap;
    public byte[][] biomemap;
    public int width;
    public int height;
    public int biomeWidth;
    public int biomeHeight;
    public BufferedImage heightmapImage;
    public BufferedImage biomemapImage;
    private Map<Integer, BiomeGenBase> biomes = new HashMap<Integer, BiomeGenBase>();
    private double biomemapToHeightmapWidthRatio;
    private double biomemapToHeightmapHeightRatio;
    private boolean loaded;

    public abstract String getBiomeMapLocation();

    public abstract String getHeightmapLocation();

    public abstract double getWorldScale();

    public abstract int adjustHeight(int var1, int var2, int var3);

    public abstract IBlockState getStoneBlock();

    public abstract BiomeGenBase getDefaultBiome();

    public abstract String getName();

    public abstract int getColourForBiome(BiomeGenBase var1);

    public int getWorldOffsetX() {
        return this.width / 2;
    }

    public int getWorldOffsetZ() {
        return this.height / 2;
    }

    public abstract boolean hasOcean();

    public abstract IBlockState getOceanLiquid();

    public abstract int getOceanHeight(int var1, int var2);

    public abstract int getOutOfBoundsHeight(int var1, int var2);

    public abstract boolean loadHeightmapIntoArray();

    public abstract boolean loadBiomemapIntoArray();

    public void loadHeightmap() {
        LLibrary.logger.info("Loading " + this.getName() + " Heightmap...");
        try {
            BufferedImage image = ImageIO.read(LLibrary.class.getResourceAsStream(this.getHeightmapLocation()));
            this.width = image.getWidth();
            this.height = image.getHeight();
            if (this.loadHeightmapIntoArray()) {
                this.heightmap = new byte[this.width][this.height];
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        this.heightmap[x][y] = (byte)(this.getHeightmapImageValue(image, x, y) - 128);
                    }
                }
            } else {
                this.heightmapImage = image;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadBiomemap() {
        String biomeMapLocation = this.getBiomeMapLocation();
        if (biomeMapLocation != null) {
            LLibrary.logger.info("Loading " + this.getName() + " Biomemap..");
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                this.biomes.put(this.getColourForBiome(biome), biome);
            }
            try {
                BufferedImage biomeImage = ImageIO.read(LLibrary.class.getResourceAsStream(biomeMapLocation));
                this.biomeWidth = biomeImage.getWidth();
                this.biomeHeight = biomeImage.getHeight();
                if (this.loadBiomemapIntoArray()) {
                    this.biomemap = new byte[this.biomeWidth][this.biomeHeight];
                    for (int y = 0; y < this.biomeHeight; ++y) {
                        for (int x = 0; x < this.biomeWidth; ++x) {
                            this.biomemap[x][y] = (byte)this.getBiomeImageValue((BufferedImage)biomeImage, (int)x, (int)y).field_76756_M;
                        }
                    }
                } else {
                    this.biomemapImage = biomeImage;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.biomemapToHeightmapHeightRatio = (double)this.biomeHeight / (double)this.height;
            this.biomemapToHeightmapWidthRatio = (double)this.biomeWidth / (double)this.width;
        }
    }

    public BiomeGenBase getBiomeImageValue(BufferedImage image, int x, int y) {
        BiomeGenBase biome = this.getDefaultBiome();
        int rgb = image.getRGB(x, y);
        for (Map.Entry<Integer, BiomeGenBase> entry : this.biomes.entrySet()) {
            if (!this.isSimilarColour(rgb, entry.getKey())) continue;
            biome = entry.getValue();
            break;
        }
        return biome;
    }

    public int getHeightmapImageValue(BufferedImage image, int x, int y) {
        return Math.min(this.adjustHeight(x, y, image.getColorModel().getRed(image.getRaster().getDataElements(x, y, null))), 255);
    }

    public int getHeight(int x, int y) {
        if (this.loadHeightmapIntoArray()) {
            return this.heightmap[x][y] + 128;
        }
        return this.getHeightmapImageValue(this.heightmapImage, x, y);
    }

    private boolean isSimilarColour(int colour, int desiredColour) {
        int r1 = colour & 0xFF;
        int g1 = colour >> 8 & 0xFF;
        int b1 = colour >> 16 & 0xFF;
        int r2 = desiredColour & 0xFF;
        int g2 = desiredColour >> 8 & 0xFF;
        int b2 = desiredColour >> 16 & 0xFF;
        return Math.abs(r1 - r2) + Math.abs(g1 - g2) + Math.abs(b1 - b2) < 10;
    }

    public int getHeightForCoords(int x, int z) {
        double scale = this.getWorldScale();
        int scaledWidth = (int)((double)this.width * scale);
        int scaledHeight = (int)((double)this.height * scale);
        x = (int)((double)x + (double)this.getWorldOffsetX() * scale);
        z = (int)((double)z + (double)this.getWorldOffsetZ() * scale);
        double[][] buffer = new double[4][4];
        double xScaled = (double)x / (double)(scaledWidth - 1) * (double)(this.width - 1);
        double yScaled = (double)z / (double)(scaledHeight - 1) * (double)(this.height - 1);
        int xOrigin = (int)xScaled;
        int yOrigin = (int)yScaled;
        double xIntermediate = xScaled - (double)xOrigin;
        double yIntermediate = yScaled - (double)yOrigin;
        for (int u = 0; u < 4; ++u) {
            for (int v = 0; v < 4; ++v) {
                buffer[u][v] = this.extract(xOrigin - 1 + u, yOrigin - 1 + v);
            }
        }
        int value = (int)Math.round(BiCubic.bicubic(buffer, xIntermediate, yIntermediate));
        value = Math.min(255, Math.max(value, 0));
        return value;
    }

    public BiomeGenBase getBiomeForCoords(int x, int z) {
        if (this.biomemap != null) {
            double scale = this.getWorldScale();
            int scaledWidth = (int)((double)this.width * scale);
            int scaledHeight = (int)((double)this.height * scale);
            x = (int)((double)x + (double)this.getWorldOffsetX() * scale);
            z = (int)((double)z + (double)this.getWorldOffsetZ() * scale);
            if (x < 0 || z < 0 || x >= scaledWidth || z >= scaledHeight) {
                return this.getDefaultBiome();
            }
            double newX = (double)x * this.biomemapToHeightmapWidthRatio / scale;
            double newZ = (double)z * this.biomemapToHeightmapHeightRatio / scale;
            return this.getBiome((int)Math.round(newX), (int)Math.round(newZ));
        }
        return this.getDefaultBiome();
    }

    public BiomeGenBase getBiome(int x, int y) {
        if (this.loadBiomemapIntoArray()) {
            return BiomeGenBase.func_150568_d((int)this.biomemap[x][y]);
        }
        return this.getBiomeImageValue(this.biomemapImage, x, y);
    }

    public void load() {
        this.loaded = true;
        this.loadHeightmap();
        this.loadBiomemap();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static double cubic(double[] p, double x) {
        return p[1] + 0.5 * x * (p[2] - p[0] + x * (2.0 * p[0] - 5.0 * p[1] + 4.0 * p[2] - p[3] + x * (3.0 * (p[1] - p[2]) + p[3] - p[0])));
    }

    public double extract(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return Math.min(Math.max(0, this.getOutOfBoundsHeight(x, y)), 255);
        }
        return this.getHeight(x, y);
    }

    private static class BiCubic {
        private static ThreadLocal<double[]> ARR_THREADSAFE = new ThreadLocal<double[]>(){

            @Override
            protected double[] initialValue() {
                return new double[4];
            }
        };

        private BiCubic() {
        }

        public static double bicubic(double[][] p, double x, double y) {
            double[] arr = ARR_THREADSAFE.get();
            arr[0] = WorldHeightmapGenerator.cubic(p[0], y);
            arr[1] = WorldHeightmapGenerator.cubic(p[1], y);
            arr[2] = WorldHeightmapGenerator.cubic(p[2], y);
            arr[3] = WorldHeightmapGenerator.cubic(p[3], y);
            return WorldHeightmapGenerator.cubic(arr, x);
        }
    }
}

