/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.lang;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.lang.RemoteLanguageContainer;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum LanguageHandler {
    INSTANCE;

    private Map<String, Map<String, String>> localizations = new HashMap<String, Map<String, String>>();

    public RemoteLanguageContainer loadRemoteLocalization(String modId) throws Exception {
        InputStream in = LanguageHandler.class.getResourceAsStream("/assets/" + modId.toLowerCase() + "/lang.json");
        if (in != null) {
            return (RemoteLanguageContainer)new Gson().fromJson((Reader)new InputStreamReader(in), RemoteLanguageContainer.class);
        }
        return null;
    }

    public void load() {
        File cacheDir = new File("llibrary/lang");
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        for (File child : cacheDir.listFiles()) {
            if (!child.isFile()) continue;
            try {
                Map lang = LanguageMap.parseLangFile((InputStream)new FileInputStream(child));
                this.localizations.put(child.getName().split("\\.")[0], lang);
            }
            catch (Exception e) {
                LLibrary.LOGGER.error("An exception occurred while loading " + child.getName() + " from cache.", (Throwable)e);
            }
        }
        for (ModContainer modContainer : Loader.instance().getModList()) {
            String modId = modContainer.getModId();
            try {
                RemoteLanguageContainer container = this.loadRemoteLocalization(modId);
                if (container == null) continue;
                for (RemoteLanguageContainer.LangContainer language : container.languages) {
                    Map lang = LanguageMap.parseLangFile((InputStream)new URL(language.downloadURL).openStream());
                    String locale = language.locale;
                    if (this.localizations.containsKey(locale)) {
                        lang.putAll(this.localizations.get(locale));
                    }
                    this.localizations.put(locale, lang);
                }
            }
            catch (Exception e) {
                LLibrary.LOGGER.error("An exception occurred while loading remote lang container for " + modId, (Throwable)e);
            }
        }
        for (Map.Entry entry : this.localizations.entrySet()) {
            String language = (String)entry.getKey();
            File cache = new File(cacheDir, language + ".lang");
            try {
                if (!cache.exists()) {
                    cache.createNewFile();
                }
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache), Charsets.UTF_8));
                for (Map.Entry langEntry : ((Map)entry.getValue()).entrySet()) {
                    out.append((CharSequence)langEntry.getKey()).append("=").append((CharSequence)langEntry.getValue()).append("\n");
                }
                out.close();
            }
            catch (Exception e) {
                LLibrary.LOGGER.error("An exception occurred while saving cache for " + language);
            }
        }
    }

    public void addRemoteLocalizations(String language, Map<String, String> properties) {
        Map<String, String> localizationsForLang = this.localizations.get(language);
        if (localizationsForLang != null) {
            properties.putAll(localizationsForLang);
        }
    }
}

