/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.config;

import com.google.common.collect.SetMultimap;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.config.Config;
import net.ilexiconn.llibrary.server.config.ConfigEntry;
import net.ilexiconn.llibrary.server.config.entry.EntryAdapters;
import net.ilexiconn.llibrary.server.config.entry.IEntryAdapter;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public enum ConfigHandler {
    INSTANCE;

    private Map<Class<?>, IEntryAdapter<?>> entryAdapters = new HashMap();
    private Map<String, Object> configObjects = new HashMap<String, Object>();
    private Map<Object, Configuration> configurations = new HashMap<Object, Configuration>();
    private Map<Configuration, Map<String, Object>> defaultValues = new HashMap<Configuration, Map<String, Object>>();
    private Map<Configuration, Map<String, IEntryAdapter<?>>> adapters = new HashMap();

    public <T> void registerEntryAdapter(Class<T> type, IEntryAdapter<T> entryAdapter) {
        this.entryAdapters.put(type, entryAdapter);
    }

    public boolean hasConfigForID(String modid) {
        return this.configObjects.containsKey(modid);
    }

    public Configuration getConfigForID(String modid) {
        if (this.hasConfigForID(modid)) {
            return this.configurations.get(this.getObjectForID(modid, Object.class));
        }
        return null;
    }

    @Deprecated
    public Object getObjectForID(String modid) {
        return this.getObjectForID(modid, Object.class);
    }

    public <T> T getObjectForID(String modid, Class<T> type) {
        if (this.hasConfigForID(modid)) {
            return type.cast(this.configObjects.get(modid));
        }
        return null;
    }

    public void saveConfigForID(String modid) {
        if (this.hasConfigForID(modid)) {
            Object object = this.configObjects.get(modid);
            Configuration config = this.configurations.get(object);
            Map<String, Object> defaultValues = this.defaultValues.get(config);
            Map<String, IEntryAdapter<?>> adapters = this.adapters.get(config);
            Arrays.stream(object.getClass().getFields()).filter(field -> field.isAnnotationPresent(ConfigEntry.class)).forEach(field -> {
                try {
                    String name;
                    IEntryAdapter entryAdapter;
                    ConfigEntry entry = field.getAnnotation(ConfigEntry.class);
                    if ((entry.side().isServer() || FMLCommonHandler.instance().getSide().isClient()) && (entryAdapter = (IEntryAdapter)adapters.get(name = entry.name().isEmpty() ? field.getName() : entry.name())) != null) {
                        entryAdapter.getProperty(config, name, entry, defaultValues.get(name)).set(String.valueOf(field.get(object)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            config.save();
            this.loadConfigForID(modid);
        }
    }

    public void loadConfigForID(String modid) {
        if (this.hasConfigForID(modid)) {
            Object object = this.configObjects.get(modid);
            Configuration config = this.configurations.get(object);
            Map<String, Object> defaultValues = this.defaultValues.get(config);
            Map<String, IEntryAdapter<?>> adapters = this.adapters.get(config);
            Arrays.stream(object.getClass().getFields()).filter(field -> field.isAnnotationPresent(ConfigEntry.class)).forEach(field -> {
                try {
                    String name;
                    IEntryAdapter entryAdapter;
                    ConfigEntry entry = field.getAnnotation(ConfigEntry.class);
                    if ((entry.side().isServer() || FMLCommonHandler.instance().getSide().isClient()) && (entryAdapter = (IEntryAdapter)adapters.get(name = entry.name().isEmpty() ? field.getName() : entry.name())) != null) {
                        field.set(object, entryAdapter.getValue(config, name, entry, defaultValues.get(name)));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            config.save();
        }
    }

    public void injectConfig(ModContainer mod, ASMDataTable data) {
        SetMultimap annotations = data.getAnnotationsFor(mod);
        if (annotations != null) {
            Set targetList = annotations.get((Object)Config.class.getName());
            ModClassLoader classLoader = Loader.instance().getModClassLoader();
            for (ASMDataTable.ASMData target : targetList) {
                try {
                    Class<?> targetClass = Class.forName(target.getClassName(), true, (ClassLoader)classLoader);
                    Field field = targetClass.getDeclaredField(target.getObjectName());
                    field.setAccessible(true);
                    Class<?> configClass = field.getType();
                    File configFile = new File(".", "config" + File.separator + mod.getModId() + ".cfg");
                    field.set(null, INSTANCE.registerConfig(mod, configFile, configClass.newInstance()));
                }
                catch (Exception e) {
                    LLibrary.LOGGER.fatal("Failed to inject config for mod container " + mod, (Throwable)e);
                }
            }
        }
    }

    private <T> T registerConfig(ModContainer mod, File file, T config) {
        this.configObjects.put(mod.getModId(), config);
        Configuration configuration = new Configuration(file);
        this.configurations.put(config, configuration);
        HashMap defaultValues = new HashMap();
        HashMap adapters = new HashMap();
        Arrays.stream(config.getClass().getFields()).filter(field -> field.isAnnotationPresent(ConfigEntry.class)).forEach(field -> {
            try {
                ConfigEntry entry = field.getAnnotation(ConfigEntry.class);
                if (entry.side().isServer() || FMLCommonHandler.instance().getSide().isClient()) {
                    String name = entry.name().isEmpty() ? field.getName() : entry.name();
                    IEntryAdapter<?> entryAdapter = EntryAdapters.getBuiltinAdapter(field.getType());
                    if (entryAdapter == null) {
                        entryAdapter = this.entryAdapters.get(field.getType());
                    }
                    if (entryAdapter != null) {
                        field.setAccessible(true);
                        defaultValues.put(name, field.get(config));
                        adapters.put(name, entryAdapter);
                    } else {
                        LLibrary.LOGGER.error("Found unsupported config entry " + field.getName() + " for mod " + mod.getName());
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.defaultValues.put(configuration, defaultValues);
        this.adapters.put(configuration, adapters);
        this.loadConfigForID(mod.getModId());
        return config;
    }
}

