/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.animationapi.client;

import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.animationapi.client.AnimID;
import net.timeless.unilib.client.model.json.TabulaModelHelper;
import net.timeless.unilib.client.model.tools.MowzieModelRenderer;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.ModelDinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.fx.EntityFXBlood;

@SideOnly(value=Side.CLIENT)
public class JabelarAnimationHelper {
    private final EntityDinosaur theEntity;
    private final Minecraft mc;
    private final Map<AnimID, int[][]> mapOfSequences;
    private final MowzieModelRenderer[][] arrayOfPoses;
    private MowzieModelRenderer[] theModelRendererArray;
    private MowzieModelRenderer[] nextPoseModel;
    private float[][] currentRotationArray;
    private float[][] currentPositionArray;
    private float[][] currentOffsetArray;
    private float[][] rotationIncrementArray;
    private float[][] positionIncrementArray;
    private float[][] offsetIncrementArray;
    private final int numParts;
    private AnimID currentSequence;
    private int numPosesInSequence;
    private int currentPose;
    private int numTicksInTween;
    private int currentTickInTween;
    private float partialTicks;
    private int lastTicksExisted;
    private final boolean inertialTweens;

    public JabelarAnimationHelper(EntityDinosaur parEntity, ModelDinosaur parModel, int parNumParts, MowzieModelRenderer[][] parArrayOfPoses, Map<AnimID, int[][]> parMapOfSequences, boolean parInertialTweens) {
        this.theEntity = parEntity;
        this.numParts = parNumParts;
        this.arrayOfPoses = parArrayOfPoses;
        this.mapOfSequences = parMapOfSequences;
        this.inertialTweens = parInertialTweens;
        this.lastTicksExisted = this.theEntity.field_70173_aa;
        this.partialTicks = 0.0f;
        this.mc = Minecraft.func_71410_x();
        this.init(parModel);
        JurassiCraft.instance.getLogger().debug("Finished JabelarAnimation constructor");
    }

    public void performJabelarAnimations(float parPartialTicks) {
        this.performBloodSpurt();
        if (this.theEntity.getAnimID() != this.currentSequence && this.currentSequence != AnimID.DYING) {
            this.setNextSequence(this.theEntity.getAnimID());
        }
        this.performNextTweenTick();
        this.partialTicks = parPartialTicks;
    }

    private void init(ModelDinosaur parModel) {
        this.initSequence(this.theEntity.getAnimID());
        JurassiCraft.instance.getLogger().info("Initializing to animation sequence = " + (Object)((Object)this.currentSequence));
        this.initPoseModel();
        this.initTweenTicks();
        this.theModelRendererArray = this.convertPassedInModelToModelRendererArray(parModel);
        this.currentRotationArray = new float[this.numParts][3];
        this.currentPositionArray = new float[this.numParts][3];
        this.currentOffsetArray = new float[this.numParts][3];
        this.updateCurrentPoseArrays();
        this.rotationIncrementArray = new float[this.numParts][3];
        this.positionIncrementArray = new float[this.numParts][3];
        this.offsetIncrementArray = new float[this.numParts][3];
        this.updateIncrementArrays();
    }

    private void initSequence(AnimID parSequenceIndex) {
        if (this.mapOfSequences.get((Object)parSequenceIndex) == null) {
            JurassiCraft.instance.getLogger().error("Requested an anim id " + parSequenceIndex.toString() + " that doesn't have animation sequence in map for entity " + this.theEntity.func_145782_y());
            this.currentSequence = AnimID.IDLE;
            this.theEntity.setAnimID(AnimID.IDLE);
        } else if (this.currentSequence != AnimID.IDLE && this.currentSequence == parSequenceIndex) {
            JurassiCraft.instance.getLogger().debug("Intializing to idle sequence");
            this.currentSequence = AnimID.IDLE;
            this.theEntity.setAnimID(AnimID.IDLE);
        } else {
            this.currentSequence = this.theEntity.isCarcass() ? AnimID.DYING : parSequenceIndex;
        }
    }

    private void initPoseModel() {
        this.numPosesInSequence = this.mapOfSequences.get((Object)this.currentSequence).length;
        this.currentPose = this.theEntity.isCarcass() ? this.numPosesInSequence - 1 : 0;
        this.nextPoseModel = this.arrayOfPoses[this.mapOfSequences.get((Object)this.currentSequence)[this.currentPose][0]];
    }

    private void setNextPoseModel(int parPose) {
        this.numPosesInSequence = this.mapOfSequences.get((Object)this.currentSequence).length;
        this.currentPose = parPose;
        this.nextPoseModel = this.arrayOfPoses[this.mapOfSequences.get((Object)this.currentSequence)[this.currentPose][0]];
    }

    private void initTweenTicks() {
        this.numTicksInTween = this.mapOfSequences.get((Object)this.currentSequence)[this.currentPose][1];
        if (this.numTicksInTween < 1) {
            JurassiCraft.instance.getLogger().error("Array of sequences has sequence with num ticks illegal value (< 1)");
            this.numTicksInTween = 1;
        }
        this.currentTickInTween = this.theEntity.isCarcass() ? this.numTicksInTween - 1 : 0;
    }

    private void startNextTween() {
        this.numTicksInTween = this.mapOfSequences.get((Object)this.currentSequence)[this.currentPose][1];
        if (this.numTicksInTween < 1) {
            JurassiCraft.instance.getLogger().error("Array of sequences has sequence with num ticks illegal value (< 1)");
            this.numTicksInTween = 1;
        }
        this.currentTickInTween = 0;
    }

    private void updateIncrementArrays() {
        float inertiaFactor = this.calculateInertiaFactor();
        for (int partIndex = 0; partIndex < this.numParts; ++partIndex) {
            this.rotationIncrementArray[partIndex][0] = (this.nextPoseModel[partIndex].field_78795_f - this.currentRotationArray[partIndex][0]) * inertiaFactor;
            this.rotationIncrementArray[partIndex][1] = (this.nextPoseModel[partIndex].field_78796_g - this.currentRotationArray[partIndex][1]) * inertiaFactor;
            this.rotationIncrementArray[partIndex][2] = (this.nextPoseModel[partIndex].field_78808_h - this.currentRotationArray[partIndex][2]) * inertiaFactor;
            this.positionIncrementArray[partIndex][0] = (this.nextPoseModel[partIndex].field_78800_c - this.currentPositionArray[partIndex][0]) * inertiaFactor;
            this.positionIncrementArray[partIndex][1] = (this.nextPoseModel[partIndex].field_78797_d - this.currentPositionArray[partIndex][1]) * inertiaFactor;
            this.positionIncrementArray[partIndex][2] = (this.nextPoseModel[partIndex].field_78798_e - this.currentPositionArray[partIndex][2]) * inertiaFactor;
            this.offsetIncrementArray[partIndex][0] = (this.nextPoseModel[partIndex].field_82906_o - this.currentOffsetArray[partIndex][0]) * inertiaFactor;
            this.offsetIncrementArray[partIndex][1] = (this.nextPoseModel[partIndex].field_82908_p - this.currentOffsetArray[partIndex][1]) * inertiaFactor;
            this.offsetIncrementArray[partIndex][2] = (this.nextPoseModel[partIndex].field_82907_q - this.currentOffsetArray[partIndex][2]) * inertiaFactor;
        }
    }

    private void updateCurrentPoseArrays() {
        for (int partIndex = 0; partIndex < this.numParts; ++partIndex) {
            this.currentRotationArray[partIndex][0] = this.theModelRendererArray[partIndex].field_78795_f;
            this.currentRotationArray[partIndex][1] = this.theModelRendererArray[partIndex].field_78796_g;
            this.currentRotationArray[partIndex][2] = this.theModelRendererArray[partIndex].field_78808_h;
            this.currentPositionArray[partIndex][0] = this.theModelRendererArray[partIndex].field_78800_c;
            this.currentPositionArray[partIndex][1] = this.theModelRendererArray[partIndex].field_78797_d;
            this.currentPositionArray[partIndex][2] = this.theModelRendererArray[partIndex].field_78798_e;
            this.currentOffsetArray[partIndex][0] = this.theModelRendererArray[partIndex].field_82906_o;
            this.currentOffsetArray[partIndex][1] = this.theModelRendererArray[partIndex].field_82908_p;
            this.currentOffsetArray[partIndex][2] = this.theModelRendererArray[partIndex].field_82907_q;
        }
    }

    private MowzieModelRenderer[] convertPassedInModelToModelRendererArray(ModelDinosaur parModel) {
        String[] partNameArray = parModel.getCubeNamesArray();
        MowzieModelRenderer[] modelRendererArray = new MowzieModelRenderer[this.numParts];
        for (int i = 0; i < this.numParts; ++i) {
            modelRendererArray[i] = parModel.getCube(partNameArray[i]);
        }
        return modelRendererArray;
    }

    private void setNextPoseModel() {
        this.nextPoseModel = this.arrayOfPoses[this.mapOfSequences.get((Object)this.currentSequence)[this.currentPose][0]];
        this.numTicksInTween = this.mapOfSequences.get((Object)this.currentSequence)[this.currentPose][1];
        this.currentTickInTween = 0;
    }

    private void performNextTweenTick() {
        this.tween();
        if (this.theEntity.field_70173_aa > this.lastTicksExisted) {
            this.lastTicksExisted = this.theEntity.field_70173_aa;
            if (this.incrementTweenTick()) {
                this.handleFinishedPose();
            }
        }
    }

    private void tween() {
        JurassiCraft.instance.getLogger().debug("current tween tick +  partial ticks = " + ((float)this.currentTickInTween + this.partialTicks));
        for (int partIndex = 0; partIndex < this.numParts; ++partIndex) {
            if (this.nextPoseModel == null) {
                JurassiCraft.instance.getLogger().error("Trying to tween to a null next pose array");
                continue;
            }
            if (this.nextPoseModel[partIndex] == null) {
                JurassiCraft.instance.getLogger().error("The part index " + partIndex + " in next pose is null");
                continue;
            }
            if (this.currentRotationArray == null) {
                JurassiCraft.instance.getLogger().error("Trying to tween from a null current rotation array");
                continue;
            }
            this.updateIncrementArrays();
            this.nextTweenRotations(partIndex);
            this.nextTweenPositions(partIndex);
            this.nextTweenOffsets(partIndex);
        }
    }

    private void nextTweenRotations(int parPartIndex) {
        this.theModelRendererArray[parPartIndex].field_78795_f = this.currentRotationArray[parPartIndex][0] + this.rotationIncrementArray[parPartIndex][0];
        this.theModelRendererArray[parPartIndex].field_78796_g = this.currentRotationArray[parPartIndex][1] + this.rotationIncrementArray[parPartIndex][1];
        this.theModelRendererArray[parPartIndex].field_78808_h = this.currentRotationArray[parPartIndex][2] + this.rotationIncrementArray[parPartIndex][2];
    }

    private void nextTweenPositions(int parPartIndex) {
        this.theModelRendererArray[parPartIndex].field_78800_c = this.currentPositionArray[parPartIndex][0] + this.positionIncrementArray[parPartIndex][0];
        this.theModelRendererArray[parPartIndex].field_78797_d = this.currentPositionArray[parPartIndex][1] + this.positionIncrementArray[parPartIndex][1];
        this.theModelRendererArray[parPartIndex].field_78798_e = this.currentPositionArray[parPartIndex][2] + this.positionIncrementArray[parPartIndex][2];
    }

    private void nextTweenOffsets(int parPartIndex) {
        this.theModelRendererArray[parPartIndex].field_82906_o = this.currentOffsetArray[parPartIndex][0] + this.offsetIncrementArray[parPartIndex][0];
        this.theModelRendererArray[parPartIndex].field_82908_p = this.currentOffsetArray[parPartIndex][1] + this.offsetIncrementArray[parPartIndex][1];
        this.theModelRendererArray[parPartIndex].field_82907_q = this.currentOffsetArray[parPartIndex][2] + this.offsetIncrementArray[parPartIndex][2];
    }

    private float calculateInertiaFactor() {
        double inertiaFactor = ((float)this.currentTickInTween + this.partialTicks) / (float)this.numTicksInTween;
        if (this.inertialTweens) {
            inertiaFactor = 0.5 + 0.5 * Math.sin(Math.PI * (inertiaFactor - 0.5));
        }
        return (float)inertiaFactor;
    }

    private void handleFinishedPose() {
        if (this.incrementCurrentPose()) {
            this.setNextSequence(this.theEntity.getAnimID());
        }
        this.updateCurrentPoseArrays();
        this.setNextPoseModel();
    }

    public boolean incrementTweenTick() {
        JurassiCraft.instance.getLogger().info("current tween step = " + this.currentTickInTween);
        ++this.currentTickInTween;
        return this.currentTickInTween >= this.numTicksInTween;
    }

    public boolean incrementCurrentPose() {
        boolean finishedSequence = false;
        ++this.currentPose;
        if (this.currentPose >= this.numPosesInSequence) {
            if (this.theEntity.getAnimID() == AnimID.DYING) {
                --this.currentPose;
            } else {
                this.currentPose = 0;
                finishedSequence = true;
            }
        }
        JurassiCraft.instance.getLogger().debug("Next pose is pose = " + this.currentPose);
        return finishedSequence;
    }

    private void setNextSequence(AnimID parSequenceIndex) {
        if (this.mapOfSequences.get((Object)parSequenceIndex) == null) {
            JurassiCraft.instance.getLogger().error("Requested an anim id " + parSequenceIndex.toString() + " that doesn't have animation sequence in map for entity " + this.theEntity.func_145782_y());
            this.currentSequence = AnimID.IDLE;
        } else if (this.currentSequence != AnimID.IDLE && this.currentSequence == parSequenceIndex) {
            JurassiCraft.instance.getLogger().debug("Reverting to idle sequence");
            this.currentSequence = AnimID.IDLE;
        } else {
            JurassiCraft.instance.getLogger().debug("Setting new sequence to " + (Object)((Object)parSequenceIndex));
            this.currentSequence = parSequenceIndex;
        }
        this.theEntity.setAnimID(this.currentSequence);
        this.setNextPoseModel(0);
        this.startNextTween();
        if (this.currentSequence != AnimID.IDLE) {
            JurassiCraft.instance.getLogger().debug("current sequence for entity ID " + this.theEntity.func_145782_y() + " is " + (Object)((Object)this.currentSequence) + " out of " + this.mapOfSequences.size() + " and current pose " + this.currentPose + " out of " + this.mapOfSequences.get((Object)this.currentSequence).length + " with " + this.numTicksInTween + " ticks in tween");
        }
    }

    public int getCurrentPose() {
        return this.currentPose;
    }

    public static ModelDinosaur getTabulaModel(String tabulaModel, int geneticVariant) {
        try {
            return new ModelDinosaur(TabulaModelHelper.parseModel(tabulaModel), null);
        }
        catch (Exception e) {
            JurassiCraft.instance.getLogger().error("Could not load Tabula model = " + tabulaModel);
            return null;
        }
    }

    public ModelDinosaur getTabulaModel(String tabulaModel) {
        return JabelarAnimationHelper.getTabulaModel(tabulaModel, 0);
    }

    private void performBloodSpurt() {
        double posX = this.theEntity.field_70165_t;
        double posY = this.theEntity.field_70163_u;
        double posZ = this.theEntity.field_70161_v;
        World world = this.theEntity.field_70170_p;
        EffectRenderer effectRenderer = this.mc.field_71452_i;
        if (this.theEntity.field_70737_aN == this.theEntity.field_70738_aO - 1) {
            float entityWidth = this.theEntity.field_70130_N;
            float entityHeight = this.theEntity.field_70131_O;
            for (float x = 0.0f; x < entityWidth; x += 1.0f) {
                for (float y = 0.0f; y < entityHeight; y += 1.0f) {
                    for (float z = 0.0f; z < entityWidth; z += 1.0f) {
                        this.addBloodEffect(world, effectRenderer, (double)x + posX - (double)(entityWidth / 2.0f), (double)y + posY, (double)z + posZ - (double)(entityWidth / 2.0f));
                    }
                }
            }
        }
    }

    private void addBloodEffect(World world, EffectRenderer effectRenderer, double x, double y, double z) {
        effectRenderer.func_78873_a((EntityFX)new EntityFXBlood(world, x + 0.5, y + 0.5, z + 0.5, 0.0, 0.0, 0.0).func_174846_a(new BlockPos(x, y, z)));
    }
}

