/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.unilib.asm;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.TraceClassVisitor;

@IFMLLoadingPlugin.Name(value="MyCoreMod")
@IFMLLoadingPlugin.MCVersion(value="1.8")
@IFMLLoadingPlugin.TransformerExclusions(value={"net.timeless.asm"})
@IFMLLoadingPlugin.SortingIndex(value=0x7FFFFFFF)
public class ASMTransformer
implements IClassTransformer {
    private final File folder = new File(".", "asm/debug");
    private final List<String> filesToDebug;

    public ASMTransformer() {
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        this.filesToDebug = Lists.newArrayList();
        String options = System.getProperty("unilibAsmDebug");
        if (options != null) {
            String[] classes;
            for (String clazz : classes = options.split(";")) {
                this.filesToDebug.add(clazz.replace(".", "/"));
            }
        }
    }

    public byte[] transform(String className, String s1, byte[] bytes) {
        String name = className.replace(".", "/");
        if (name.equals("net/minecraft/item/ItemStack")) {
            ClassReader reader = new ClassReader(bytes);
            ClassWriter writer = new ClassWriter(2);
            reader.accept((ClassVisitor)new UniItemStackTransformer(327680, writer), 8);
            bytes = writer.toByteArray();
        }
        if (this.filesToDebug.contains(name)) {
            try {
                File textFile = this.createFile(this.folder, className, "txt");
                ClassReader reader = new ClassReader(bytes);
                TraceClassVisitor visitor = new TraceClassVisitor(new PrintWriter(new FileWriter(textFile)));
                reader.accept((ClassVisitor)visitor, 0);
                File classFile = this.createFile(this.folder, className, "class");
                try (FileOutputStream out = new FileOutputStream(classFile);){
                    out.write(bytes);
                    out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    private File createFile(File folder, String className, String extension) throws IOException {
        File result = new File(folder, className.replace(".", "/") + "." + extension);
        if (!result.getParentFile().exists()) {
            result.getParentFile().mkdirs();
        }
        result.createNewFile();
        return result;
    }

    private class MetadataGetterTransformer
    extends MethodVisitor
    implements Opcodes {
        private final Label endLabel;

        public MetadataGetterTransformer(int api, MethodVisitor mv) {
            super(api, mv);
            this.endLabel = new Label();
        }

        public void visitLabel(Label label) {
            super.visitLabel(label);
        }

        public void visitInsn(int opcode) {
            if (opcode == 176) {
                super.visitInsn(89);
                super.visitJumpInsn(198, this.endLabel);
                super.visitInsn(176);
                super.visitLabel(this.endLabel);
                super.visitInsn(87);
                super.visitFieldInsn(178, "net/minecraft/init/Items", "stick", "Lnet/minecraft/item/Item;");
                super.visitInsn(176);
            } else {
                super.visitInsn(opcode);
            }
        }
    }

    private class UniItemStackTransformer
    extends ClassVisitor {
        public UniItemStackTransformer(int api, ClassWriter writer) {
            super(api, (ClassVisitor)writer);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals("getItem")) {
                return new MetadataGetterTransformer(this.api, mv);
            }
            return mv;
        }
    }
}

