/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.unilib.client.model.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.client.model.tools.MowzieModelRenderer;

@SideOnly(value=Side.CLIENT)
public class MowzieModelBase
extends ModelBase {
    protected List<MowzieModelRenderer> parts;
    private float movementScale = 1.0f;

    public ModelRenderer func_85181_a(Random rand) {
        if (this.parts.size() > 0) {
            return this.parts.get(rand.nextInt(this.parts.size()));
        }
        return super.func_85181_a(rand);
    }

    public void setMovementScale(float scale) {
        this.movementScale = scale;
    }

    protected void setInitPose() {
        for (int i = 0; i < this.parts.size(); ++i) {
            this.parts.get(i).setInitValuesToCurrentPose();
        }
    }

    public void setToInitPose() {
        for (int i = 0; i < this.parts.size(); ++i) {
            this.parts.get(i).setCurrentPoseToInitValues();
        }
    }

    protected void addChildTo(ModelRenderer child, ModelRenderer parent) {
        float distance = (float)Math.sqrt(Math.pow(child.field_78798_e - parent.field_78798_e, 2.0) + Math.pow(child.field_78797_d - parent.field_78797_d, 2.0));
        float oldRotateAngleX = parent.field_78795_f;
        float parentToChildAngle = (float)Math.atan((child.field_78798_e - parent.field_78798_e) / (child.field_78797_d - parent.field_78797_d));
        float childRelativeRotation = parentToChildAngle - parent.field_78795_f;
        float newRotationPointY = (float)((double)distance * Math.cos(childRelativeRotation));
        float newRotationPointZ = (float)((double)distance * Math.sin(childRelativeRotation));
        parent.field_78795_f = 0.0f;
        child.func_78793_a(child.field_78800_c - parent.field_78800_c, newRotationPointY, newRotationPointZ);
        parent.func_78792_a(child);
        parent.field_78795_f = oldRotateAngleX;
        child.field_78795_f -= parent.field_78795_f;
        child.field_78796_g -= parent.field_78796_g;
        child.field_78808_h -= parent.field_78808_h;
    }

    public void faceTarget(MowzieModelRenderer box, float f, float f3, float f4) {
        box.field_78796_g += f3 / 57.295776f / f;
        box.field_78795_f += f4 / 57.295776f / f;
    }

    public float rotateBox(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        if (invert) {
            return -MathHelper.func_76134_b((float)(f * speed + offset)) * degree * f1 + weight * f1;
        }
        return MathHelper.func_76134_b((float)(f * speed + offset)) * degree * f1 + weight * f1;
    }

    public float moveBox(float speed, float degree, boolean bounce, float f, float f1) {
        if (bounce) {
            return -MathHelper.func_76135_e((float)(MathHelper.func_76126_a((float)(f * speed)) * f1 * degree));
        }
        return MathHelper.func_76126_a((float)(f * speed)) * f1 * degree - f1 * degree;
    }

    public void walk(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78795_f += MathHelper.func_76134_b((float)(f * (speed *= this.movementScale) + offset)) * (degree *= this.movementScale) * (float)inverted * f1 + weight * f1;
    }

    public void flap(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78808_h += MathHelper.func_76134_b((float)(f * speed + offset)) * degree * (float)inverted * f1 + weight * f1;
    }

    public void swing(MowzieModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        int inverted = 1;
        if (invert) {
            inverted = -1;
        }
        box.field_78796_g += MathHelper.func_76134_b((float)(f * (speed *= this.movementScale) + offset)) * (degree *= this.movementScale) * (float)inverted * f1 + weight * f1;
    }

    public void bob(MowzieModelRenderer box, float speed, float degree, boolean bounce, float f, float f1) {
        float bob = (float)(Math.sin(f * speed) * (double)f1 * (double)degree - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        degree *= this.movementScale;
        speed *= this.movementScale;
        box.field_78797_d += bob;
    }

    public void chainSwing(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        degree *= this.movementScale;
        speed *= this.movementScale;
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78796_g += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    public void chainWave(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        degree *= this.movementScale;
        speed *= this.movementScale;
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78795_f += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    public void chainFlap(MowzieModelRenderer[] boxes, float speed, float degree, double rootOffset, float f, float f1) {
        int numberOfSegments = boxes.length;
        float offset = (float)(rootOffset * Math.PI / (double)(2 * numberOfSegments));
        degree *= this.movementScale;
        speed *= this.movementScale;
        for (int i = 0; i < numberOfSegments; ++i) {
            boxes[i].field_78808_h += MathHelper.func_76134_b((float)(f * speed + offset * (float)i)) * f1 * degree;
        }
    }

    protected void rotateTo(ModelRenderer rotating, ModelRenderer to, float t) {
        float rotXDif = to.field_78795_f - rotating.field_78795_f;
        float rotYDif = to.field_78796_g - rotating.field_78796_g;
        float rotZDif = to.field_78808_h - rotating.field_78808_h;
        float posXDif = to.field_78800_c - rotating.field_78800_c;
        float posYDif = to.field_78797_d - rotating.field_78797_d;
        float posZDif = to.field_78798_e - rotating.field_78798_e;
        float offsetXDif = to.field_82906_o - rotating.field_82906_o;
        float offsetYDif = to.field_82908_p - rotating.field_82908_p;
        float offsetZDif = to.field_82907_q - rotating.field_82907_q;
        rotating.field_78795_f += rotXDif / 20.0f * t;
        rotating.field_78796_g += rotYDif / 20.0f * t;
        rotating.field_78808_h += rotZDif / 20.0f * t;
        rotating.field_82906_o += offsetXDif / 20.0f * t;
        rotating.field_82908_p += offsetYDif / 20.0f * t;
        rotating.field_82907_q += offsetZDif / 20.0f * t;
        rotating.field_78800_c += posXDif / 20.0f * t;
        rotating.field_78797_d += posYDif / 20.0f * t;
        rotating.field_78798_e += posZDif / 20.0f * t;
    }

    public void addPart(MowzieModelRenderer mowzieModelRenderer) {
        if (this.parts == null) {
            this.parts = new ArrayList<MowzieModelRenderer>();
        }
        this.parts.add(mowzieModelRenderer);
    }
}

