/*
 * Decompiled with CFR 0.152.
 */
package net.timeless.unilib.common.animation;

import java.util.Random;
import net.minecraft.util.MathHelper;

public class IntermittentAnimation {
    private double timer = 0.0;
    private double duration;
    private boolean runInterval;
    private int inverter;
    private double timerInterval;
    private double intervalDuration;
    private int goChance;
    private int returnChance;
    private Random random = new Random();

    public IntermittentAnimation(int d, int i, int c, int r) {
        this.duration = d;
        this.intervalDuration = i;
        this.runInterval = true;
        this.goChance = c;
        this.returnChance = r;
        this.inverter = -1;
    }

    public void setDuration(int d) {
        this.timer = 0.0;
        this.duration = d;
    }

    public double getTimer() {
        return this.timer;
    }

    public void setTimer(int time) {
        this.timer = time;
        if (this.timer > this.duration) {
            this.timer = this.duration;
        } else if (this.timer < 0.0) {
            this.timer = 0.0;
        }
    }

    public void resetTimer() {
        this.timer = 0.0;
    }

    public void runAnimation() {
        if (!this.runInterval) {
            if (this.timer < this.duration && this.timer > 0.0) {
                this.timer += (double)this.inverter;
            } else {
                if (this.timer >= this.duration) {
                    this.timer = this.duration;
                } else if (this.timer <= 0.0) {
                    this.timer = 0.0;
                }
                this.timerInterval = 0.0;
                this.runInterval = true;
            }
        } else if (this.timerInterval < this.intervalDuration) {
            this.timerInterval += 1.0;
        } else {
            if (this.inverter > 0 && this.random.nextInt(this.returnChance) == 0) {
                this.inverter = -1;
            }
            if (this.inverter < 0 && this.random.nextInt(this.goChance) == 0) {
                this.inverter = 1;
            }
            this.timer += (double)this.inverter;
            this.runInterval = false;
        }
    }

    public void stopAnimation() {
        if (this.timer > 0.0) {
            this.timer -= 1.0;
        } else {
            this.timer = 0.0;
            this.runInterval = true;
            this.timerInterval = 0.0;
            this.inverter = 1;
        }
    }

    public void stopAnimation(int time) {
        if (this.timer - (double)time > 0.0) {
            this.timer -= (double)time;
        } else {
            this.timer = 0.0;
            this.runInterval = false;
            this.timerInterval = 0.0;
            this.inverter = 1;
        }
    }

    public float getAnimationFraction() {
        return (float)(this.timer / this.duration);
    }

    public float getAnimationProgressSmooth() {
        if (this.timer > 0.0) {
            if (this.timer < this.duration) {
                return (float)(1.0 / (1.0 + Math.exp(4.0 - 8.0 * (this.timer / this.duration))));
            }
            return 1.0f;
        }
        return 0.0f;
    }

    public float getAnimationProgressSteep() {
        return (float)(1.0 / (1.0 + Math.exp(6.0 - 12.0 * (this.timer / this.duration))));
    }

    public float getAnimationProgressSin() {
        return MathHelper.func_76126_a((float)(1.5707964f * (float)(this.timer / this.duration)));
    }

    public float getAnimationProgressSinSqrt() {
        float result = MathHelper.func_76126_a((float)(1.5707964f * (float)(this.timer / this.duration)));
        return result * result;
    }

    public float getAnimationProgressSinToTen() {
        return (float)Math.pow(MathHelper.func_76126_a((float)(1.5707964f * (float)(this.timer / this.duration))), 10.0);
    }

    public float getAnimationProgressSinPowerOf(int i) {
        return (float)Math.pow(MathHelper.func_76126_a((float)(1.5707964f * (float)(this.timer / this.duration))), i);
    }

    public float getAnimationProgressPoly2() {
        float x = (float)(this.timer / this.duration);
        float x2 = x * x;
        return x2 / (x2 + (1.0f - x) * (1.0f - x));
    }

    public float getAnimationProgressPoly3() {
        float x = (float)(this.timer / this.duration);
        float x3 = x * x * x;
        return x3 / (x3 + (1.0f - x) * (1.0f - x) * (1.0f - x));
    }

    public float getAnimationProgressPolyN(int n) {
        double x = this.timer / this.duration;
        double xi = Math.pow(x, n);
        return (float)(xi / (xi + Math.pow(1.0 - x, n)));
    }

    public float getAnimationProgressArcTan() {
        return (float)(0.5 + (double)0.4980651f * Math.atan(3.14159265359 * (this.timer / this.duration - 0.5)));
    }

    public float getAnimationProgressTemporary() {
        float x = (float)Math.PI * 2 * (float)(this.timer / this.duration);
        return 0.5f - 0.5f * MathHelper.func_76134_b((float)(x + MathHelper.func_76126_a((float)x)));
    }

    public float getAnimationProgressTemporaryFS() {
        float x = (float)Math.PI * (float)(this.timer / this.duration);
        return MathHelper.func_76126_a((float)(x + MathHelper.func_76126_a((float)x)));
    }

    public float getAnimationProgressTemporaryInvesed() {
        float x = (float)Math.PI * 2 * (float)(this.timer / this.duration);
        return 0.5f + 0.5f * MathHelper.func_76134_b((float)(x + MathHelper.func_76126_a((float)x)));
    }
}

