/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui.app;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.ResourceLocation;
import org.jurassicraft.client.gui.GuiPaleoPad;
import org.jurassicraft.client.gui.app.GuiApp;
import org.jurassicraft.common.paleopad.App;
import org.jurassicraft.common.paleopad.AppDinoPedia;
import org.jurassicraft.common.paleopad.dinopedia.DinoPediaRegistry;

public class GuiAppDinoPedia
extends GuiApp {
    private static final ResourceLocation texture = new ResourceLocation("jurassicraft", "textures/gui/paleo_pad/apps/dinopedia.png");
    private final RenderItem render = Minecraft.func_71410_x().func_175599_af();
    private boolean intro;

    public GuiAppDinoPedia(App app) {
        super(app);
    }

    @Override
    public void render(int mouseX, int mouseY, GuiPaleoPad gui) {
        super.renderButtons(mouseX, mouseY, gui);
        AppDinoPedia app = (AppDinoPedia)this.app;
        if (this.intro) {
            gui.drawScaledText("Hello " + GuiAppDinoPedia.mc.field_71439_g.func_145748_c_().func_150254_d() + "! Welcome to " + app.getName() + "!", 4, 10, 1.0f, 0xFFFFFF);
            mc.func_110434_K().func_110577_a(texture);
            gui.drawScaledTexturedModalRect(1, 20, 0, 0, 32, 32, 32, 32, 1.0f);
            gui.drawScaledText("Using " + app.getName() + " you can find all the information", 34, 29, 0.7f, 0xFFFFFF);
            gui.drawScaledText("you need to start creating living dinosaurs!", 34, 37, 0.7f, 0xFFFFFF);
        } else {
            gui.drawScaledText("Items:", 4, 5, 1.0f, 0xFFFFFF);
            this.drawItemsAndRecipes(gui, app);
        }
    }

    private void drawItemsAndRecipes(GuiPaleoPad gui, AppDinoPedia app) {
        List<ItemStack> items = DinoPediaRegistry.getItems();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        int renderX = 0;
        int renderY = 0;
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (stack == null) continue;
            GlStateManager.func_179094_E();
            if (app.getSelectedItem() == i) {
                gui.drawBoxOutline(renderX + 4, renderY + 14, 18, 18, 1, 1.0f, 0x606060);
            }
            ScaledResolution dimensions = new ScaledResolution(mc);
            GlStateManager.func_179109_b((float)(dimensions.func_78326_a() / 2 - 115), (float)75.0f, (float)0.0f);
            this.render.field_77023_b = 200.0f;
            this.render.func_180450_b(stack, renderX + 5, renderY + 6);
            this.render.field_77023_b = 0.0f;
            if (app.getSelectedItem() == i) {
                GlStateManager.func_179109_b((float)70.0f, (float)10.0f, (float)0.0f);
                List<IRecipe> recipes = DinoPediaRegistry.getRecipesForItem(stack);
                gui.drawCenteredScaledText("Recipe:", -120, -12, 1.0f, 0xFFFFFF);
                gui.drawCenteredScaledText(stack.func_82833_r(), -120, -80, 1.0f, 0xFFFFFF);
                this.render.field_77023_b = 200.0f;
                this.render.func_180450_b(stack, 75, -8);
                this.render.field_77023_b = 0.0f;
                for (IRecipe recipe : recipes) {
                    if (!(recipe instanceof ShapedRecipes)) continue;
                    ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
                    ItemStack[] recipeItems = shapedRecipe.field_77574_d;
                    int rx = 0;
                    int ry = 0;
                    for (int r = 0; r < recipeItems.length; ++r) {
                        ItemStack item = recipeItems[r];
                        gui.drawBoxOutline(rx * 19 - 150, ry * 19, 18, 18, 1, 1.0f, r % 2 == 0 ? 0x606060 : 0x404040);
                        if (item != null) {
                            this.render.field_77023_b = 200.0f;
                            this.render.func_180450_b(item, rx * 19 + 56, ry * 19 + 67);
                            this.render.field_77023_b = 0.0f;
                        }
                        if (++rx < 3) continue;
                        rx = 0;
                        ++ry;
                    }
                }
            }
            if ((renderY += 18) > 120) {
                renderY = 0;
                renderX += 19;
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, GuiPaleoPad gui) {
        ScaledResolution dimensions = new ScaledResolution(mc);
        mouseX -= dimensions.func_78326_a() / 2 - 115;
        mouseY -= 75;
        if (!this.intro) {
            AppDinoPedia app = (AppDinoPedia)this.getApp();
            List<ItemStack> items = DinoPediaRegistry.getItems();
            int renderX = 0;
            int renderY = 0;
            for (int i = 0; i < items.size(); ++i) {
                ItemStack stack = items.get(i);
                if (stack == null) continue;
                if (mouseX > renderX && mouseX < renderX + 18 && mouseY > renderY && mouseY < renderY + 18) {
                    app.setSelectedItem(i);
                    break;
                }
                if ((renderY += 18) <= 120) continue;
                renderY = 0;
                renderX += 19;
            }
        }
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    @Override
    public void init() {
        this.intro = !this.app.hasBeenPreviouslyOpened();
    }

    @Override
    public ResourceLocation getTexture(GuiPaleoPad gui) {
        return texture;
    }
}

