/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.gui.app;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.jurassicraft.client.gui.GuiPaleoPad;
import org.jurassicraft.client.gui.app.GuiApp;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.paleopad.App;
import org.jurassicraft.common.paleopad.AppMinimap;
import org.lwjgl.opengl.GL11;

public class GuiAppMinimap
extends GuiApp {
    private static final ResourceLocation texture = new ResourceLocation("jurassicraft", "textures/gui/paleo_pad/apps/minimap.png");
    private static final ResourceLocation entity = new ResourceLocation("jurassicraft", "textures/gui/paleo_pad/apps/background/entity.png");

    public GuiAppMinimap(App app) {
        super(app);
    }

    @Override
    public void render(int mouseX, int mouseY, GuiPaleoPad gui) {
        Chunk chunk;
        int chunkZ;
        int chunkX;
        super.renderButtons(mouseX, mouseY, gui);
        AppMinimap app = (AppMinimap)this.getApp();
        EntityPlayerSP player = GuiAppMinimap.mc.field_71439_g;
        WorldClient world = GuiAppMinimap.mc.field_71441_e;
        gui.drawScaledText("Loc: " + (int)player.field_70165_t + " " + (int)player.field_70163_u + " " + (int)player.field_70161_v, 2, 3, 1.0f, 0xFFFFFF);
        int playerX = (int)player.field_70165_t;
        int playerZ = (int)player.field_70161_v;
        int playerChunkX = playerX >> 4;
        int playerChunkZ = playerZ >> 4;
        int mapX = 0;
        int renderY = 0;
        int renderChunkX = 0;
        int renderChunkY = 0;
        for (chunkX = playerChunkX - 4; chunkX < playerChunkX + 4; ++chunkX) {
            for (chunkZ = playerChunkZ - 4; chunkZ < playerChunkZ + 4; ++chunkZ) {
                chunk = world.func_72964_e(chunkX, chunkZ);
                if (!chunk.func_76621_g()) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int blockZ;
                            int blockX = x + chunkX * 16;
                            int blockY = chunk.func_76611_b(x, z);
                            if (world.func_175623_d(new BlockPos(blockX, blockY, blockZ = z + chunkZ * 16))) {
                                --blockY;
                            }
                            IBlockState blockState = world.func_180495_p(new BlockPos(blockX, blockY, blockZ));
                            Block block = blockState.func_177230_c();
                            MapColor color = block.func_180659_g(blockState);
                            int rgb = color.field_76291_p;
                            gui.drawScaledRect(mapX + renderChunkX * 16 + 90, renderY + renderChunkY * 16 + 15, 1, 1, 1.0f, rgb);
                            ++renderY;
                        }
                        renderY = 0;
                        ++mapX;
                    }
                }
                mapX = 0;
                renderY = 0;
                gui.drawBoxOutline(renderChunkX * 16 + 90, renderChunkY * 16 - 1, 15, 15, 1, 1.0f, (renderChunkX + ++renderChunkY) % 2 == 0 ? 0x606060 : 0x505050);
            }
            renderChunkY = 0;
            ++renderChunkX;
        }
        renderChunkX = 0;
        renderChunkY = 0;
        for (chunkX = playerChunkX - 4; chunkX < playerChunkX + 4; ++chunkX) {
            for (chunkZ = playerChunkZ - 4; chunkZ < playerChunkZ + 4; ++chunkZ) {
                chunk = world.func_72964_e(chunkX, chunkZ);
                if (!chunk.func_76621_g()) {
                    for (Entity e : this.getEntitiesInChunk(chunk, null, (Predicate<Entity>)EntitySelectors.field_180132_d)) {
                        Entity entity = e;
                        if (entity instanceof EntityDinosaur) {
                            EntityDinosaur dino = (EntityDinosaur)entity;
                            if (!dino.hasTracker()) continue;
                            Dinosaur dinosaur = dino.getDinosaur();
                            int colour = dino.isMale() ? dinosaur.getEggPrimaryColorMale() : dinosaur.getEggPrimaryColorFemale();
                            float red = (float)(colour >> 16 & 0xFF) / 255.0f;
                            float green = (float)(colour >> 8 & 0xFF) / 255.0f;
                            float blue = (float)(colour & 0xFF) / 255.0f;
                            GL11.glColor3f((float)red, (float)green, (float)blue);
                            mc.func_110434_K().func_110577_a(GuiAppMinimap.entity);
                            int dinoX = (int)dino.field_70165_t;
                            int dinoZ = (int)dino.field_70161_v;
                            int entityRenderX = (dinoX & 0xF) + renderChunkX * 16 + 90 - 4;
                            int entityRenderY = (dinoZ & 0xF) + renderChunkY * 16 + 15 - 4;
                            gui.drawScaledTexturedModalRect(entityRenderX, entityRenderY, 0, 0, 16, 16, 16, 16, 0.6f);
                            gui.drawCenteredScaledText(dinoX + " " + (int)dino.field_70163_u + " " + dinoZ, entityRenderX + 5, entityRenderY + 8, 0.3f, 0xFFFFFF);
                            continue;
                        }
                        if (player != entity) continue;
                        mc.func_110434_K().func_110577_a(GuiAppMinimap.entity);
                        gui.drawScaledTexturedModalRect((playerX & 0xF) + renderChunkX * 16 + 90 - 4, (playerZ & 0xF) + renderChunkY * 16 + 15 - 4, 0, 0, 16, 16, 16, 16, 0.6f);
                    }
                }
                ++renderChunkY;
            }
            renderChunkY = 0;
            ++renderChunkX;
        }
    }

    public List<Entity> getEntitiesInChunk(Chunk chunk, Entity exclude, Predicate<Entity> predicate) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        int i = MathHelper.func_76128_c((double)((0.0 - World.MAX_ENTITY_RADIUS) / 16.0));
        int j = MathHelper.func_76128_c((double)((256.0 + World.MAX_ENTITY_RADIUS) / 16.0));
        ClassInheritanceMultiMap[] entityLists = chunk.func_177429_s();
        i = MathHelper.func_76125_a((int)i, (int)0, (int)(entityLists.length - 1));
        j = MathHelper.func_76125_a((int)j, (int)0, (int)(entityLists.length - 1));
        for (int k = i; k <= j; ++k) {
            for (Entity entity : entityLists[k]) {
                if (entity == exclude || predicate != null && !predicate.apply((Object)entity)) continue;
                entities.add(entity);
                Entity[] parts = entity.func_70021_al();
                if (parts == null) continue;
                for (Entity part : parts) {
                    entity = part;
                    if (entity == exclude || predicate != null && !predicate.apply((Object)entity)) continue;
                    entities.add(entity);
                }
            }
        }
        return entities;
    }

    @Override
    public void actionPerformed(GuiButton button) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, GuiPaleoPad gui) {
        ScaledResolution dimensions = new ScaledResolution(mc);
        mouseX -= dimensions.func_78326_a() / 2 - 115;
        mouseY -= 65;
    }

    @Override
    public void init() {
    }

    @Override
    public ResourceLocation getTexture(GuiPaleoPad gui) {
        return texture;
    }
}

