/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.model.animation.vehicle;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.client.model.json.IModelAnimator;
import net.timeless.unilib.client.model.json.ModelJson;
import net.timeless.unilib.client.model.tools.MowzieModelRenderer;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;

@SideOnly(value=Side.CLIENT)
public class AnimationHelicopter
implements IModelAnimator {
    private float partialTicks = 0.0f;

    @Override
    public void setRotationAngles(ModelJson model, float f, float f1, float rotation, float rotationYaw, float rotationPitch, Entity entity) {
        EntityHelicopterBase helicopter = (EntityHelicopterBase)entity;
        MowzieModelRenderer rotor = model.getCube("rotorbase_rotatehere");
        MowzieModelRenderer tailrotor = model.getCube("tailrotor_rotatehere");
        float time = helicopter.getEnginePower() / 80.0f;
        rotor.field_78796_g = this.easeInCubic(time, rotor.field_78796_g, helicopter.getEnginePower() * this.partialTicks, 1.0f);
        rotor.field_78796_g %= 360.0f;
        tailrotor.field_78795_f = this.easeInCubic(time, tailrotor.field_78795_f, helicopter.getEnginePower() * this.partialTicks, 1.0f);
        tailrotor.field_78795_f %= 360.0f;
    }

    @Override
    public void preRenderCallback(EntityLivingBase entity, float partialTicks) {
        this.partialTicks = partialTicks;
    }

    private float easeInCubic(float time, float startValue, float change, float duration) {
        return change * (time /= duration) * time * time + startValue;
    }
}

