/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.render.entity.IDinosaurRenderer;
import org.jurassicraft.client.render.renderdef.RenderDinosaurDefinition;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.EntityVelociraptor;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaurFlyingAggressive;
import org.jurassicraft.common.entity.base.EnumGrowthStage;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderDinosaur
extends RenderLiving
implements IDinosaurRenderer {
    private static final DynamicTexture dynamicTexture = new DynamicTexture(16, 16);
    public Dinosaur dinosaur;
    public RenderDinosaurDefinition renderDef;
    public Random random;

    public RenderDinosaur(RenderDinosaurDefinition renderDef) {
        super(Minecraft.func_71410_x().func_175598_ae(), renderDef.getModel(EnumGrowthStage.INFANT), renderDef.getShadowSize());
        this.dinosaur = renderDef.getDinosaur();
        this.random = new Random();
        this.renderDef = renderDef;
        for (int i = 0; i < this.dinosaur.getOverlayCount(); ++i) {
            this.func_177094_a(new LayerDinosaurVariations(this, i));
        }
    }

    public void func_77041_b(EntityLivingBase entity, float partialTick) {
        EntityDinosaur entityDinosaur = (EntityDinosaur)entity;
        this.renderDef.getModelAnimator().preRenderCallback((EntityLivingBase)entityDinosaur, partialTick);
        if (entity instanceof EntityDinosaurFlyingAggressive && ((EntityDinosaurFlyingAggressive)entity).isFlying()) {
            GlStateManager.func_179114_b((float)(-entity.field_70125_A / 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float scale = (float)entityDinosaur.transitionFromAge(this.renderDef.getBabyScaleAdjustment(), this.renderDef.getAdultScaleAdjustment());
        this.field_76989_e = scale * this.renderDef.getShadowSize();
        GL11.glTranslatef((float)(this.renderDef.getRenderXOffset() * scale), (float)(this.renderDef.getRenderYOffset() * scale), (float)(this.renderDef.getRenderZOffset() * scale));
        String name = entity.func_95999_t();
        if (entity instanceof EntityVelociraptor && (name.equals("iLexiconn") || name.equals("JTGhawk137"))) {
            GL11.glScalef((float)(scale - 0.86f), (float)scale, (float)scale);
        } else if (name.equals("Gegy")) {
            int ticksExisted = entity.field_70173_aa / 25 + entity.func_145782_y();
            int colorTypes = EnumDyeColor.values().length;
            int k = ticksExisted % colorTypes;
            int l = (ticksExisted + 1) % colorTypes;
            float time = ((float)(entity.field_70173_aa % 25) + 2.0f) / 25.0f;
            float[] colors = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
            float[] colors2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
            GlStateManager.func_179124_c((float)(colors[0] * (1.0f - time) + colors2[0] * time), (float)(colors[1] * (1.0f - time) + colors2[1] * time), (float)(colors[2] * (1.0f - time) + colors2[2] * time));
            if (time > 0.5f) {
                time = 1.0f - time;
            }
            GL11.glScalef((float)(scale * (0.5f + time * 0.5f)), (float)(scale * (1.0f + time * 0.5f)), (float)(scale * (0.9f + time * 0.25f)));
        } else if (name.equals("Notch") || name.equals("Jumbo")) {
            GL11.glScalef((float)(scale * 2.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
        } else if (name.equals("jglrxavpok")) {
            GL11.glScalef((float)scale, (float)scale, (float)(scale * -1.0f));
        } else {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
    }

    protected boolean func_177092_a(EntityLivingBase entitylivingbaseIn, float partialTicks, boolean combineTextures) {
        float f1 = entitylivingbaseIn.func_70013_c(partialTicks);
        int i = this.func_77030_a(entitylivingbaseIn, f1, partialTicks);
        boolean flag1 = (i >> 24 & 0xFF) > 0;
        boolean flag2 = false;
        if (!flag1 && !flag2) {
            return false;
        }
        if (!flag1 && !combineTextures) {
            return false;
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GL11.glTexEnvi((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_77478_a);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176093_u);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_77478_a);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179098_w();
        GL11.glTexEnvi((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176099_x, (int)OpenGlHelper.field_176094_t);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176092_v);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_176091_w);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176080_A, (int)OpenGlHelper.field_176092_v);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176076_D, (int)770);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        this.field_177095_g.position(0);
        if (flag2) {
            this.field_177095_g.put(1.0f);
            this.field_177095_g.put(0.0f);
            this.field_177095_g.put(0.0f);
            this.field_177095_g.put(0.3f);
        } else {
            float f2 = (float)(i >> 24 & 0xFF) / 255.0f;
            float f3 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(i & 0xFF) / 255.0f;
            this.field_177095_g.put(f3);
            this.field_177095_g.put(f4);
            this.field_177095_g.put(f5);
            this.field_177095_g.put(1.0f - f2);
        }
        this.field_177095_g.flip();
        GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)this.field_177095_g);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_176096_r);
        GlStateManager.func_179098_w();
        GlStateManager.func_179144_i((int)dynamicTexture.func_110552_b());
        GL11.glTexEnvi((int)8960, (int)8704, (int)OpenGlHelper.field_176095_s);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176099_x, (int)8448);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176098_y, (int)OpenGlHelper.field_176091_w);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176097_z, (int)OpenGlHelper.field_77476_b);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176081_B, (int)768);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176082_C, (int)768);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176077_E, (int)7681);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176078_F, (int)OpenGlHelper.field_176091_w);
        GL11.glTexEnvi((int)8960, (int)OpenGlHelper.field_176085_I, (int)770);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        return true;
    }

    public ResourceLocation getEntityTexture(EntityDinosaur entity) {
        return entity.isMale() ? this.dinosaur.getMaleTexture(entity.getGrowthStage()) : this.dinosaur.getFemaleTexture(entity.getGrowthStage());
    }

    public ResourceLocation func_110775_a(Entity entity) {
        return this.getEntityTexture((EntityDinosaur)entity);
    }

    protected void func_77043_a(EntityLivingBase parEntity, float p_77043_2_, float p_77043_3_, float p_77043_4_) {
        if (parEntity.field_70725_aQ <= 0) {
            super.func_77043_a(parEntity, p_77043_2_, p_77043_3_, p_77043_4_);
        } else {
            GlStateManager.func_179114_b((float)(180.0f - p_77043_3_), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    @Override
    public void setModel(ModelBase model) {
        this.field_77045_g = model;
    }

    @Override
    public RenderDinosaurDefinition getRenderDef() {
        return this.renderDef;
    }

    @SideOnly(value=Side.CLIENT)
    public class LayerDinosaurVariations
    implements LayerRenderer {
        private final RenderDinosaur renderer;
        private final int index;

        public LayerDinosaurVariations(RenderDinosaur renderer, int index) {
            this.renderer = renderer;
            this.index = index;
        }

        public void render(EntityDinosaur entity, float armSwing, float armSwingAmount, float p_177148_4_, float p_177148_5_, float p_177148_6_, float p_177148_7_, float partialTicks) {
            ResourceLocation texture;
            if (!entity.func_82150_aj() && (texture = this.renderer.dinosaur.getOverlayTexture(entity.getGrowthStage(), entity.getOverlay(this.index))) != null) {
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glEnable((int)3042);
                GlStateManager.func_179131_c((float)((float)entity.getOverlayR() / 255.0f), (float)((float)entity.getOverlayG() / 255.0f), (float)((float)entity.getOverlayB() / 255.0f), (float)0.2f);
                this.renderer.func_110776_a(texture);
                this.renderer.func_177087_b().func_78088_a((Entity)entity, armSwing, armSwingAmount, p_177148_5_, p_177148_6_, p_177148_7_, partialTicks);
                this.renderer.func_177105_a((EntityLiving)entity, p_177148_4_);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        public boolean func_177142_b() {
            return true;
        }

        public void func_177141_a(EntityLivingBase entity, float p_177141_2_, float p_177141_3_, float p_177141_4_, float p_177141_5_, float p_177141_6_, float p_177141_7_, float p_177141_8_) {
            this.render((EntityDinosaur)entity, p_177141_2_, p_177141_3_, p_177141_4_, p_177141_5_, p_177141_6_, p_177141_7_, p_177141_8_);
        }
    }
}

