/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.client.render.WorldRendererUtils;
import org.jurassicraft.common.entity.item.EntityPaddockSign;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderPaddockSign
extends Render {
    private static final ResourceLocation texture = new ResourceLocation("jurassicraft", "textures/paddock/paddock_signs.png");

    public RenderPaddockSign() {
        super(Minecraft.func_71410_x().func_175598_ae());
    }

    public void doRender(EntityPaddockSign entity, double x, double y, double z, float yaw, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179114_b((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179091_B();
        this.func_180548_c((Entity)entity);
        float scale = 0.0625f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        int id = entity.getDinosaur();
        this.drawPaddockSign(entity, 16, 16, id % 16 * 16, (int)Math.floor(id / 16) * 16);
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
        super.func_76986_a((Entity)entity, x, y, z, yaw, partialTicks);
    }

    protected ResourceLocation getPaddockTexture(EntityPaddockSign sign) {
        return texture;
    }

    private void drawPaddockSign(EntityPaddockSign sign, int width, int height, int u, int v) {
        float f = (float)(-width) / 2.0f;
        float f1 = (float)(-height) / 2.0f;
        float f2 = 0.0f;
        float f3 = 0.75f;
        float f4 = 0.8125f;
        float f5 = 0.0f;
        float f6 = 0.0625f;
        float f9 = 0.001953125f;
        float f10 = 0.001953125f;
        float f13 = 0.0f;
        float f14 = 0.0625f;
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.45f);
        for (int i1 = 0; i1 < width / 16; ++i1) {
            for (int j1 = 0; j1 < height / 16; ++j1) {
                float f15 = f + (float)((i1 + 1) * 16);
                float f16 = f + (float)(i1 * 16);
                float f17 = f1 + (float)((j1 + 1) * 16);
                float f18 = f1 + (float)(j1 * 16);
                this.func_77008_a(sign, (f15 + f16) / 2.0f, (f17 + f18) / 2.0f);
                float f19 = (float)(u + width - i1 * 16) / 256.0f;
                float f20 = (float)(u + width - (i1 + 1) * 16) / 256.0f;
                float f21 = (float)(v + height - j1 * 16) / 256.0f;
                float f22 = (float)(v + height - (j1 + 1) * 16) / 256.0f;
                Tessellator tessellator = Tessellator.func_178181_a();
                WorldRenderer worldrenderer = tessellator.func_178180_c();
                WorldRendererUtils rendererUtils = new WorldRendererUtils(worldrenderer);
                rendererUtils.startDrawingQuads();
                rendererUtils.setNormal(0.0f, 0.0f, -1.0f);
                rendererUtils.addVertexWithUV(f15, f18, -f2, f20, f21);
                rendererUtils.addVertexWithUV(f16, f18, -f2, f19, f21);
                rendererUtils.addVertexWithUV(f16, f17, -f2, f19, f22);
                rendererUtils.addVertexWithUV(f15, f17, -f2, f20, f22);
                rendererUtils.setNormal(0.0f, 0.0f, 1.0f);
                rendererUtils.addVertexWithUV(f15, f17, f2, f3, f5);
                rendererUtils.addVertexWithUV(f16, f17, f2, f4, f5);
                rendererUtils.addVertexWithUV(f16, f18, f2, f4, f6);
                rendererUtils.addVertexWithUV(f15, f18, f2, f3, f6);
                rendererUtils.setNormal(0.0f, 1.0f, 0.0f);
                rendererUtils.addVertexWithUV(f15, f17, -f2, 0.0, f9);
                rendererUtils.addVertexWithUV(f16, f17, -f2, 0.0, f9);
                rendererUtils.addVertexWithUV(f16, f17, f2, 0.0, f10);
                rendererUtils.addVertexWithUV(f15, f17, f2, 0.0, f10);
                rendererUtils.setNormal(0.0f, -1.0f, 0.0f);
                rendererUtils.addVertexWithUV(f15, f18, f2, 0.0, f9);
                rendererUtils.addVertexWithUV(f16, f18, f2, 0.0, f9);
                rendererUtils.addVertexWithUV(f16, f18, -f2, 0.0, f10);
                rendererUtils.addVertexWithUV(f15, f18, -f2, 0.0, f10);
                rendererUtils.setNormal(-1.0f, 0.0f, 0.0f);
                rendererUtils.addVertexWithUV(f15, f17, f2, 0.0, f13);
                rendererUtils.addVertexWithUV(f15, f18, f2, 0.0, f14);
                rendererUtils.addVertexWithUV(f15, f18, -f2, 0.0, f14);
                rendererUtils.addVertexWithUV(f15, f17, -f2, 0.0, f13);
                rendererUtils.setNormal(1.0f, 0.0f, 0.0f);
                rendererUtils.addVertexWithUV(f16, f17, -f2, 0.0, f13);
                rendererUtils.addVertexWithUV(f16, f18, -f2, 0.0, f14);
                rendererUtils.addVertexWithUV(f16, f18, f2, 0.0, f14);
                rendererUtils.addVertexWithUV(f16, f17, f2, 0.0, f13);
                tessellator.func_78381_a();
            }
        }
    }

    private void func_77008_a(EntityPaddockSign sign, float p_77008_2_, float p_77008_3_) {
        int i = MathHelper.func_76128_c((double)sign.field_70165_t);
        int j = MathHelper.func_76128_c((double)(sign.field_70163_u + (double)(p_77008_3_ / 16.0f)));
        int k = MathHelper.func_76128_c((double)sign.field_70161_v);
        EnumFacing enumfacing = sign.field_174860_b;
        if (enumfacing == EnumFacing.NORTH) {
            i = MathHelper.func_76128_c((double)(sign.field_70165_t + (double)(p_77008_2_ / 16.0f)));
        }
        if (enumfacing == EnumFacing.WEST) {
            k = MathHelper.func_76128_c((double)(sign.field_70161_v - (double)(p_77008_2_ / 16.0f)));
        }
        if (enumfacing == EnumFacing.SOUTH) {
            i = MathHelper.func_76128_c((double)(sign.field_70165_t - (double)(p_77008_2_ / 16.0f)));
        }
        if (enumfacing == EnumFacing.EAST) {
            k = MathHelper.func_76128_c((double)(sign.field_70161_v + (double)(p_77008_2_ / 16.0f)));
        }
        int l = this.field_76990_c.field_78722_g.func_175626_b(new BlockPos(i, j, k), 0);
        int i1 = l % 65536;
        int j1 = l / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)i1, (float)j1);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return this.getPaddockTexture((EntityPaddockSign)entity);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTicks) {
        this.doRender((EntityPaddockSign)entity, x, y, z, yaw, partialTicks);
    }
}

