/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.client.render.renderdef;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.unilib.client.model.json.IModelAnimator;
import net.timeless.unilib.client.model.json.ModelJson;
import net.timeless.unilib.client.model.json.TabulaModelHelper;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.client.model.ModelDinosaur;
import org.jurassicraft.client.render.entity.RenderDinosaur;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.EnumGrowthStage;

@SideOnly(value=Side.CLIENT)
public class RenderDinosaurDefinition {
    private final Dinosaur dinosaur;
    private final IModelAnimator animator;
    private final ModelJson modelAdult;
    private final ModelJson modelInfant;
    private ModelJson modelJuvenile;
    private ModelJson modelAdolescent;
    private float adultScaleAdjustment = 1.0f;
    private float babyScaleAdjustment = 0.325f;
    private float shadowSize = 0.65f;
    private float renderXOffset = 0.0f;
    private float renderYOffset = 0.0f;
    private float renderZOffset = 0.0f;

    public RenderDinosaurDefinition(Dinosaur dinosaur, IModelAnimator animator, float adultScaleAdjustment, float babyScaleAdjustment, float parShadowSize, float parRenderXOffset, float parRenderYOffset, float parRenderZOffset) {
        this.dinosaur = dinosaur;
        this.animator = animator;
        this.adultScaleAdjustment = adultScaleAdjustment;
        this.babyScaleAdjustment = babyScaleAdjustment;
        this.shadowSize = parShadowSize;
        this.renderXOffset = parRenderXOffset;
        this.renderYOffset = parRenderYOffset;
        this.renderZOffset = parRenderZOffset;
        this.modelAdult = this.getDefaultTabulaModel("adult");
        this.modelInfant = this.getDefaultTabulaModel("infant");
        if (dinosaur.useAllGrowthStages()) {
            this.modelJuvenile = this.getDefaultTabulaModel("juvenile");
            this.modelAdolescent = this.getDefaultTabulaModel("adolescent");
        }
    }

    public ModelBase getModel(EnumGrowthStage stage) {
        switch (stage) {
            case INFANT: {
                return this.modelInfant;
            }
            case JUVENILE: {
                return this.dinosaur.useAllGrowthStages() ? this.modelJuvenile : this.modelInfant;
            }
            case ADOLESCENT: {
                return this.dinosaur.useAllGrowthStages() ? this.modelAdolescent : this.modelAdult;
            }
        }
        return this.modelAdult;
    }

    public IModelAnimator getModelAnimator() {
        return this.animator;
    }

    public float getRenderXOffset() {
        return this.renderXOffset;
    }

    public float getRenderYOffset() {
        return this.renderYOffset;
    }

    public float getRenderZOffset() {
        return this.renderZOffset;
    }

    public float getAdultScaleAdjustment() {
        return this.adultScaleAdjustment;
    }

    public float getBabyScaleAdjustment() {
        return this.babyScaleAdjustment;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public ModelDinosaur getTabulaModel(String tabulaModel) throws Exception {
        return new ModelDinosaur(TabulaModelHelper.parseModel(tabulaModel), this.getModelAnimator());
    }

    public ModelDinosaur getDefaultTabulaModel(String stage) {
        String model = "/assets/jurassicraft/models/entities/" + this.dinosaur.getName().toLowerCase() + "/" + stage + "/" + this.dinosaur.getName().toLowerCase() + "_" + stage + "_idle";
        try {
            return this.getTabulaModel(model);
        }
        catch (Exception e) {
            JurassiCraft.instance.getLogger().fatal("Couldn't load model " + model, (Throwable)e);
            return null;
        }
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public RenderLiving getRenderer() {
        return new RenderDinosaur(this);
    }
}

