/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.block.tree;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.common.block.JCBlockRegistry;
import org.jurassicraft.common.block.tree.EnumType;
import org.jurassicraft.common.creativetab.JCCreativeTabs;

public class BlockJCLeaves
extends BlockLeaves {
    private EnumType treeType;

    public BlockJCLeaves(EnumType type, String name) {
        this.treeType = type;
        this.func_149663_c(name + "_leaves");
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149672_a(field_149779_h);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(JCCreativeTabs.plants);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.treeType == EnumType.GINKGO ? 0xFFFFFF : ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180644_h(IBlockState state) {
        return this.treeType == EnumType.GINKGO ? 0xFFFFFF : ColorizerFoliage.func_77468_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        return this.treeType == EnumType.GINKGO ? 0xFFFFFF : BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos);
    }

    public EnumType getTreeType() {
        return this.treeType;
    }

    protected void func_176234_a(World worldIn, BlockPos pos, IBlockState state, int chance) {
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_176214_u() {
        return Blocks.field_150362_t.func_176214_u();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(worldIn, pos, side);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0) {
            ret.add(new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state)));
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        ret.addAll(this.captureDrops(false));
        return ret;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)JCBlockRegistry.saplings[this.treeType.getMetadata()]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List list) {
        list.add(new ItemStack(itemIn, 1, 0));
    }

    public IBlockState func_176203_a(int meta) {
        boolean dec = meta < 4;
        boolean check = meta < 8;
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(dec)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(check));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i = 4;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i = 8;
        }
        return i;
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te) {
        if (!worldIn.field_72995_K && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(StatList.field_75934_C[Block.func_149682_b((Block)this)]);
            BlockJCLeaves.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this), 1, 0));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)this, 1, 0)});
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.BIRCH;
    }
}

