/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.dinosaur;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import org.jurassicraft.common.api.IHybrid;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.EnumDiet;
import org.jurassicraft.common.entity.base.EnumGrowthStage;
import org.jurassicraft.common.entity.base.EnumSleepingSchedule;
import org.jurassicraft.common.period.EnumTimePeriod;

public abstract class Dinosaur
implements Comparable<Dinosaur> {
    private Map<EnumGrowthStage, List<ResourceLocation>> overlays = new HashMap<EnumGrowthStage, List<ResourceLocation>>();
    private Map<EnumGrowthStage, ResourceLocation> maleTextures = new HashMap<EnumGrowthStage, ResourceLocation>();
    private Map<EnumGrowthStage, ResourceLocation> femaleTextures = new HashMap<EnumGrowthStage, ResourceLocation>();

    public void init() {
        String dinosaurName = this.getName().toLowerCase().replaceAll(" ", "_");
        String baseTextures = "textures/entities/" + dinosaurName + "/";
        for (EnumGrowthStage growthStage : EnumGrowthStage.values()) {
            String growthStageName = growthStage.name().toLowerCase();
            if (!this.useAllGrowthStages()) {
                if (growthStage == EnumGrowthStage.ADOLESCENT) {
                    growthStageName = EnumGrowthStage.ADULT.name().toLowerCase();
                } else if (growthStage == EnumGrowthStage.JUVENILE) {
                    growthStageName = EnumGrowthStage.INFANT.name().toLowerCase();
                }
            }
            if (this instanceof IHybrid) {
                ResourceLocation hybridTexture = new ResourceLocation("jurassicraft", baseTextures + dinosaurName + "_" + growthStageName + ".png");
                this.maleTextures.put(growthStage, hybridTexture);
                this.femaleTextures.put(growthStage, hybridTexture);
            } else {
                this.maleTextures.put(growthStage, new ResourceLocation("jurassicraft", baseTextures + dinosaurName + "_male_" + growthStageName + ".png"));
                this.femaleTextures.put(growthStage, new ResourceLocation("jurassicraft", baseTextures + dinosaurName + "_female_" + growthStageName + ".png"));
            }
            ArrayList<ResourceLocation> overlaysForGrowthStage = new ArrayList<ResourceLocation>();
            for (int i = 1; i <= this.getOverlayCount(); ++i) {
                overlaysForGrowthStage.add(new ResourceLocation("jurassicraft", baseTextures + dinosaurName + "_overlay_" + growthStageName + "_" + i + ".png"));
            }
            this.overlays.put(growthStage, overlaysForGrowthStage);
        }
    }

    public abstract String getName();

    public abstract Class<? extends EntityDinosaur> getDinosaurClass();

    public abstract int getEggPrimaryColorMale();

    public abstract int getEggSecondaryColorMale();

    public abstract int getEggPrimaryColorFemale();

    public abstract int getEggSecondaryColorFemale();

    public abstract EnumTimePeriod getPeriod();

    public abstract double getBabyHealth();

    public abstract double getAdultHealth();

    public abstract double getBabySpeed();

    public abstract double getAdultSpeed();

    public abstract double getBabyStrength();

    public abstract double getAdultStrength();

    public abstract double getBabyKnockback();

    public abstract double getAdultKnockback();

    public abstract float getBabySizeX();

    public abstract float getBabySizeY();

    public abstract float getAdultSizeX();

    public abstract float getAdultSizeY();

    public abstract float getBabyEyeHeight();

    public abstract float getAdultEyeHeight();

    public abstract int getMaximumAge();

    public ResourceLocation getMaleTexture(EnumGrowthStage stage) {
        return this.maleTextures.get((Object)stage);
    }

    public ResourceLocation getFemaleTexture(EnumGrowthStage stage) {
        return this.femaleTextures.get((Object)stage);
    }

    public double getAttackSpeed() {
        return 0.5;
    }

    public boolean shouldRegister() {
        return true;
    }

    protected String getDinosaurTexture(String subtype) {
        String dinosaurName = this.getName().toLowerCase().replaceAll(" ", "_");
        String texture = "jurassicraft:textures/entities/" + dinosaurName + "/" + dinosaurName;
        if (subtype != "") {
            texture = texture + "_" + subtype;
        }
        return texture + ".png";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    protected int fromDays(int days) {
        return days * 24000 / 8;
    }

    @Override
    public int compareTo(Dinosaur dinosaur) {
        return this.getName().compareTo(dinosaur.getName());
    }

    public boolean isMarineAnimal() {
        return false;
    }

    public boolean isMammal() {
        return false;
    }

    public int getLipids() {
        return 1500;
    }

    public int getMinerals() {
        return 1500;
    }

    public int getVitamins() {
        return 1500;
    }

    public int getProximates() {
        return 1500;
    }

    public abstract int getStorage();

    public ResourceLocation getOverlayTexture(EnumGrowthStage stage, int overlay) {
        return overlay != 255 && this.overlays.containsKey((Object)stage) ? this.overlays.get((Object)stage).get(overlay) : null;
    }

    public int getOverlayCount() {
        return 0;
    }

    public boolean useAllGrowthStages() {
        return false;
    }

    public abstract EnumDiet getDiet();

    public abstract EnumSleepingSchedule getSleepingSchedule();
}

