/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.jurassicraft.common.entity.base.EntityDinosaur;

public class EntityAISleep
extends EntityAIBase {
    protected EntityDinosaur dinosaur;
    protected BlockPos sleepPos;

    public EntityAISleep(EntityDinosaur dinosaur) {
        this.dinosaur = dinosaur;
    }

    public boolean func_75250_a() {
        World world = this.dinosaur.field_70170_p;
        if (!world.field_72995_K && this.dinosaur.shouldSleep() && !this.dinosaur.isSleeping() && this.dinosaur.shouldGoBackToSleep()) {
            int range = 16;
            int posX = (int)this.dinosaur.field_70165_t;
            int posZ = (int)this.dinosaur.field_70161_v;
            for (int x = posX - range; x < posX + range; ++x) {
                for (int z = posZ - range; z < posZ + range; ++z) {
                    BlockPos possiblePos = world.func_175672_r(new BlockPos(x, 0, z));
                    if (!world.func_175623_d(possiblePos) || world.func_180495_p(possiblePos.func_177982_a(0, -1, 0)).func_177230_c() == Blocks.field_150355_j || !this.canFit(possiblePos) || world.func_175678_i(possiblePos) || !this.dinosaur.setSleepLocation(possiblePos, true)) continue;
                    this.sleepPos = possiblePos;
                    return true;
                }
            }
            this.dinosaur.setSleepLocation(this.dinosaur.func_180425_c(), false);
            this.sleepPos = this.dinosaur.func_180425_c();
            return true;
        }
        return false;
    }

    private boolean canFit(BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        AxisAlignedBB boundingBox = AxisAlignedBB.func_178781_a((double)x, (double)y, (double)z, (double)(x + (double)this.dinosaur.field_70130_N), (double)(y + (double)this.dinosaur.field_70131_O), (double)(z + (double)this.dinosaur.field_70130_N));
        return this.dinosaur.field_70170_p.func_72945_a((Entity)this.dinosaur, boundingBox).isEmpty();
    }

    public void func_75246_d() {
        int z;
        int y;
        int x;
        if (this.dinosaur.shouldGoBackToSleep() && this.dinosaur.func_70092_e(x = this.sleepPos.func_177958_n(), y = this.sleepPos.func_177956_o(), z = this.sleepPos.func_177952_p()) / 16.0 <= (double)this.dinosaur.field_70130_N) {
            this.dinosaur.setSleeping(true);
        }
    }

    public boolean func_75253_b() {
        return this.dinosaur != null && !this.dinosaur.isCarcass() && this.sleepPos != null && !this.dinosaur.isSleeping() && this.dinosaur.shouldSleep();
    }
}

