/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.ai.metabolism;

import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.timeless.animationapi.AnimationAPI;
import net.timeless.animationapi.client.AnimID;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.MetabolismContainer;

public class EntityAIDrink
extends EntityAIBase {
    protected EntityDinosaur dinosaur;
    protected int x;
    protected int y;
    protected int z;

    public EntityAIDrink(EntityDinosaur dinosaur) {
        this.dinosaur = dinosaur;
    }

    public boolean func_75250_a() {
        MetabolismContainer metabolism = this.dinosaur.getMetabolism();
        if (!this.dinosaur.field_70128_L && !this.dinosaur.isCarcass() && this.dinosaur.field_70173_aa % 4 == 0 && this.dinosaur.field_70170_p.func_82736_K().func_82766_b("dinoMetabolism")) {
            double water = metabolism.getWater();
            boolean execute = false;
            int maxWater = metabolism.getMaxWater();
            if (water / (double)maxWater * 100.0 < 25.0) {
                execute = true;
            } else if (water < (double)(maxWater - maxWater / 8) && this.dinosaur.getDinosaur().getSleepingSchedule().isWithinEatingTime(this.dinosaur.getDinosaurTime(), this.dinosaur.func_70681_au())) {
                execute = true;
            }
            if (execute) {
                int posX = (int)this.dinosaur.field_70165_t;
                int posY = (int)this.dinosaur.field_70163_u;
                int posZ = (int)this.dinosaur.field_70161_v;
                int closestDist = Integer.MAX_VALUE;
                int closestX = 0;
                int closestY = 0;
                int closestZ = 0;
                boolean found = false;
                World world = this.dinosaur.field_70170_p;
                int range = 32;
                for (int x = posX - range; x < posX + range; ++x) {
                    for (int y = posY - range; y < posY + range; ++y) {
                        for (int z = posZ - range; z < posZ + range; ++z) {
                            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                            if (block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
                            for (int landX = x - 1; landX < x + 1; ++landX) {
                                for (int landZ = z - 1; landZ < z + 1; ++landZ) {
                                    int diffZ;
                                    int diffY;
                                    int diffX;
                                    int dist;
                                    if (!world.func_180495_p(new BlockPos(landX, y, landZ)).func_177230_c().func_149662_c() || (dist = (diffX = posX - landX) * diffX + (diffY = posY - y) * diffY + (diffZ = posZ - landZ) * diffZ) >= closestDist) continue;
                                    closestDist = dist;
                                    closestX = landX;
                                    closestY = y;
                                    closestZ = landZ;
                                    found = true;
                                }
                            }
                        }
                    }
                }
                if (found) {
                    this.x = closestX;
                    this.y = closestY;
                    this.z = closestZ;
                    this.dinosaur.func_70661_as().func_75492_a((double)this.x, (double)this.y, (double)this.z, 1.0);
                    return true;
                }
            }
        }
        return false;
    }

    public void func_75246_d() {
        if (this.dinosaur.func_70092_e(this.x, this.y, this.z) / 16.0 <= (double)this.dinosaur.field_70130_N) {
            if (this.dinosaur.getAnimID() != AnimID.DRINKING) {
                AnimationAPI.sendAnimPacket(this.dinosaur, AnimID.DRINKING);
            }
            MetabolismContainer metabolism = this.dinosaur.getMetabolism();
            metabolism.setWater(metabolism.getMaxWater());
        }
    }

    public boolean func_75253_b() {
        Block block = this.dinosaur.field_70170_p.func_180495_p(new BlockPos(this.x, this.y, this.z)).func_177230_c();
        return this.dinosaur != null && !this.dinosaur.func_70661_as().func_75500_f() && (block == Blocks.field_150355_j || block == Blocks.field_150358_i);
    }
}

