/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.base;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.timeless.animationapi.AIAnimation;
import net.timeless.animationapi.AnimationAPI;
import net.timeless.animationapi.IAnimatedEntity;
import net.timeless.animationapi.client.AnimID;
import net.timeless.unilib.common.animation.ChainBuffer;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.damagesource.EntityDinosaurDamageSource;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.ai.EntityAIHerd;
import org.jurassicraft.common.entity.ai.EntityAIMate;
import org.jurassicraft.common.entity.ai.EntityAISleep;
import org.jurassicraft.common.entity.ai.animations.AnimationAICall;
import org.jurassicraft.common.entity.ai.animations.AnimationAIHeadCock;
import org.jurassicraft.common.entity.ai.animations.AnimationAILook;
import org.jurassicraft.common.entity.ai.metabolism.EntityAIDrink;
import org.jurassicraft.common.entity.ai.metabolism.EntityAIEatFoodItem;
import org.jurassicraft.common.entity.ai.metabolism.EntityAIFindPlant;
import org.jurassicraft.common.entity.base.EnumGrowthStage;
import org.jurassicraft.common.entity.base.EnumSleepingSchedule;
import org.jurassicraft.common.entity.base.InventoryDinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.entity.base.MetabolismContainer;
import org.jurassicraft.common.genetics.GeneticsContainer;
import org.jurassicraft.common.genetics.GeneticsHelper;
import org.jurassicraft.common.item.ItemBluePrint;
import org.jurassicraft.common.item.JCItemRegistry;

public abstract class EntityDinosaur
extends EntityCreature
implements IEntityAdditionalSpawnData,
IAnimatedEntity {
    protected Dinosaur dinosaur;
    protected int dinosaurAge;
    protected int prevAge;
    private int growthSpeedOffset;
    private boolean isCarcass;
    private GeneticsContainer genetics;
    private int geneticsQuality;
    private boolean isMale;
    public AIAnimation currentAnim = null;
    private AnimID animID;
    private int animTick;
    private boolean hasTracker;
    public ChainBuffer tailBuffer;
    private UUID owner;
    private InventoryDinosaur inventory;
    private static final int WATCHER_IS_CARCASS = 25;
    private static final int WATCHER_AGE = 26;
    private static final int WATCHER_GROWTH_OFFSET = 27;
    private static final int WATCHER_HAS_TRACKER = 28;
    private static final int WATCHER_IS_SLEEPING = 29;
    private MetabolismContainer metabolism = new MetabolismContainer(this);
    private boolean isSleeping;
    private boolean goBackToSleep;

    public EntityDinosaur(World world) {
        super(world);
        this.inventory = new InventoryDinosaur(this);
        this.tailBuffer = new ChainBuffer(this.getTailBoxCount());
        if (!this.dinosaur.isMarineAnimal()) {
            this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        }
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISleep(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIDrink(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIEatFoodItem(this));
        if (this.dinosaur.getDiet().doesEatPlants()) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFindPlant(this));
        }
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIHerd(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AnimationAICall(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AnimationAILook(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AnimationAIHeadCock(this));
        this.setFullyGrown();
        this.genetics = GeneticsHelper.randomGenetics(this.field_70146_Z, this.getDinosaur(), this.getDNAQuality());
        this.isMale = this.field_70146_Z.nextBoolean();
        this.animTick = 0;
        this.setAnimID(AnimID.IDLE);
        this.goBackToSleep = true;
        this.field_70158_ak = true;
        this.updateCreatureData();
        this.adjustHitbox();
    }

    public boolean shouldSleep() {
        return this.getDinosaurTime() > this.getDinosaur().getSleepingSchedule().getAwakeTime();
    }

    public void setSleeping(boolean sleeping) {
        if (this.isSleeping != sleeping) {
            if (sleeping) {
                AnimationAPI.sendAnimPacket(this, AnimID.SLEEPING);
            } else {
                AnimationAPI.sendAnimPacket(this, AnimID.IDLE);
            }
        }
        this.isSleeping = sleeping;
    }

    public int getDinosaurTime() {
        EnumSleepingSchedule sleepingSchedule = this.getDinosaur().getSleepingSchedule();
        long time = this.field_70170_p.func_72820_D() % 24000L - (long)sleepingSchedule.getWakeUpTime();
        if (time < 0L) {
            time += 24000L;
        }
        return (int)time;
    }

    public abstract int getTailBoxCount();

    public boolean hasTracker() {
        return this.hasTracker;
    }

    public void setHasTracker(boolean hasTracker) {
        this.hasTracker = hasTracker;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(EntityPlayer player) {
        this.owner = player.func_110124_au();
    }

    public boolean func_70652_k(Entity entity) {
        EntityLivingBase theEntityLivingBase;
        AnimationAPI.sendAnimPacket(this, AnimID.ATTACKING);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (entity instanceof EntityLivingBase) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_70694_bm(), (EnumCreatureAttribute)((EntityLivingBase)entity).func_70668_bt());
            knockback += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        boolean attackSuccesful = entity.func_70097_a((DamageSource)new EntityDinosaurDamageSource("mob", (Entity)this), damage);
        if (entity instanceof EntityLivingBase && (theEntityLivingBase = (EntityLivingBase)entity).func_110143_aJ() < 0.0f) {
            AnimationAPI.sendAnimPacket(this, AnimID.IDLE);
        }
        if (attackSuccesful) {
            if (knockback > 0) {
                entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return attackSuccesful;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.getAnimID() == AnimID.IDLE) {
            AnimationAPI.sendAnimPacket(this, AnimID.INJURED);
        }
        if (this.isSleeping) {
            this.isSleeping = false;
            this.dontGoBackToSleep();
        }
        return super.func_70097_a(damageSource, amount);
    }

    public void func_70653_a(Entity entity, float p_70653_2_, double motionX, double motionZ) {
        if (this.field_70146_Z.nextDouble() >= this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111126_e()) {
            this.field_70160_al = true;
            float distance = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            float multiplier = 0.4f;
            this.field_70159_w /= 2.0;
            this.field_70179_y /= 2.0;
            this.field_70159_w -= motionX / (double)distance * (double)multiplier;
            this.field_70179_y -= motionZ / (double)distance * (double)multiplier;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        AnimationAPI.sendAnimPacket(this, AnimID.INJURED);
    }

    public void func_70642_aH() {
        AnimationAPI.sendAnimPacket(this, AnimID.LIVING_SOUND);
        super.func_70642_aH();
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)0);
        this.field_70180_af.func_75682_a(28, (Object)0);
        this.field_70180_af.func_75682_a(29, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.dinosaur = JCEntityRegistry.getDinosaurByClass(this.getClass());
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.updateCreatureData();
        this.adjustHitbox();
    }

    public void updateCreatureData() {
        double prevHealth = this.func_110138_aP();
        double newHealth = this.transitionFromAge(this.dinosaur.getBabyHealth(), this.dinosaur.getAdultHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(newHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.transitionFromAge(this.dinosaur.getBabySpeed(), this.dinosaur.getAdultSpeed()));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.transitionFromAge(this.dinosaur.getBabyKnockback(), this.dinosaur.getAdultKnockback()));
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.transitionFromAge(this.dinosaur.getBabyStrength(), this.dinosaur.getAdultStrength()));
        if (prevHealth != newHealth) {
            this.func_70691_i((float)(newHealth - (double)this.field_110153_bc));
        }
    }

    private void adjustHitbox() {
        this.func_70105_a((float)this.transitionFromAge(this.dinosaur.getBabySizeX(), this.dinosaur.getAdultSizeX()), (float)this.transitionFromAge(this.dinosaur.getBabySizeY(), this.dinosaur.getAdultSizeY()));
    }

    public double transitionFromAge(double baby, double adult) {
        int maxAge = this.dinosaur.getMaximumAge();
        if (this.dinosaurAge > maxAge) {
            this.dinosaurAge = maxAge;
        }
        return (adult - baby) / (double)maxAge * (double)this.dinosaurAge + baby;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public void applySettingsForActionFigure() {
        this.setFullyGrown();
        this.setMale(true);
        this.genetics = new GeneticsContainer(JCEntityRegistry.getDinosaurId(this.dinosaur), 0, 0, 0, 255, 255, 255);
    }

    public int func_70627_aG() {
        return 200;
    }

    public float func_70647_i() {
        return (float)this.transitionFromAge(1.5, 1.0) + (this.field_70146_Z.nextFloat() - 0.5f) * 0.125f;
    }

    public float func_70599_aP() {
        return this.isCarcass || this.isSleeping ? 0.0f : 2.0f * (float)this.transitionFromAge(0.3f, 1.0);
    }

    public void setGenetics(String genetics) {
        this.genetics = new GeneticsContainer(genetics);
    }

    public GeneticsContainer getGenetics() {
        return this.genetics;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.isCarcass) {
            if (this.field_70148_d) {
                this.updateCreatureData();
            }
            this.adjustHitbox();
            this.updateGrowth();
            this.metabolism.update();
        }
    }

    private void updateGrowth() {
        if (!this.field_70128_L && this.field_70173_aa % 8 == 0) {
            if (this.field_70170_p.func_82736_K().func_82766_b("dinoGrowth")) {
                this.dinosaurAge += Math.min(this.growthSpeedOffset, 960) + 1;
                this.metabolism.decreaseFood((int)((double)(Math.min(this.growthSpeedOffset, 960) + 1) * 0.1));
            }
            if (this.dinosaurAge % 20 == 0) {
                this.updateCreatureData();
            }
            if (this.growthSpeedOffset > 0) {
                this.growthSpeedOffset -= 10;
                if (this.growthSpeedOffset < 0) {
                    this.growthSpeedOffset = 0;
                }
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.tailBuffer.calculateChainSwingBuffer(68.0f, 5, 4.0f, (EntityLivingBase)this);
        if (!this.field_70170_p.field_72995_K) {
            if (this.prevAge != this.dinosaurAge) {
                this.field_70180_af.func_75692_b(26, (Object)this.dinosaurAge);
                this.prevAge = this.dinosaurAge;
            }
            this.field_70180_af.func_75692_b(27, (Object)this.growthSpeedOffset);
            this.field_70180_af.func_75692_b(28, (Object)(this.hasTracker ? 1 : 0));
            this.field_70180_af.func_75692_b(29, (Object)(this.isSleeping ? 1 : 0));
        } else {
            int age = this.field_70180_af.func_75679_c(26);
            if (age != this.dinosaurAge) {
                this.updateCreatureData();
                this.adjustHitbox();
                this.dinosaurAge = age;
            }
            this.growthSpeedOffset = this.field_70180_af.func_75679_c(27);
            this.hasTracker = this.field_70180_af.func_75679_c(28) == 1;
            boolean bl = this.isSleeping = this.field_70180_af.func_75679_c(29) == 1;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(25, (Object)(this.isCarcass ? 1 : 0));
        } else {
            boolean bl = this.isCarcass = this.field_70180_af.func_75679_c(25) == 1;
        }
        if (this.isCarcass && this.getAnimID() != AnimID.DYING) {
            AnimationAPI.sendAnimPacket(this, AnimID.DYING);
        }
        if (this.isSleeping) {
            if (this.getAnimID() != AnimID.SLEEPING) {
                AnimationAPI.sendAnimPacket(this, AnimID.SLEEPING);
            }
            if (!this.shouldSleep() && !this.field_70170_p.field_72995_K) {
                this.isSleeping = false;
            }
        }
        if (!this.shouldSleep() && !this.isSleeping) {
            this.goBackToSleep = true;
        }
        if (this.getAnimID() != AnimID.IDLE) {
            ++this.animTick;
        }
    }

    public boolean func_70610_aX() {
        return this.isCarcass() || this.isSleeping();
    }

    public int getDaysExisted() {
        return (int)Math.floor((float)this.dinosaurAge * 8.0f / 24000.0f);
    }

    public void setFullyGrown() {
        this.dinosaurAge = this.dinosaur.getMaximumAge();
    }

    public Dinosaur getDinosaur() {
        return this.dinosaur;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public int getDinosaurAge() {
        return this.dinosaurAge;
    }

    public void setAge(int age) {
        this.dinosaurAge = age;
    }

    public float func_70047_e() {
        return (float)this.transitionFromAge(this.dinosaur.getBabyEyeHeight(), this.dinosaur.getAdultEyeHeight());
    }

    protected void func_70628_a(boolean p_70628_1_, int looting) {
        int meatAmount = (int)((float)this.field_70146_Z.nextInt(3) + this.field_70130_N * this.field_70131_O / 4.0f) + looting;
        for (int i = 0; i < meatAmount; ++i) {
            if (this.func_70027_ad()) {
                this.dropStackWithGenetics(new ItemStack((Item)JCItemRegistry.dino_steak, 1, JCEntityRegistry.getDinosaurId(this.dinosaur)));
                continue;
            }
            this.dropStackWithGenetics(new ItemStack((Item)JCItemRegistry.dino_meat, 1, JCEntityRegistry.getDinosaurId(this.dinosaur)));
        }
        this.inventory.dropItems(this.field_70170_p, this.field_70146_Z);
    }

    private void dropStackWithGenetics(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("DNAQuality", this.geneticsQuality);
        nbt.func_74778_a("Genetics", this.genetics.toString());
        stack.func_77982_d(nbt);
        this.func_70099_a(stack, 0.0f);
    }

    public void setCarcass(boolean carcass) {
        String s;
        if (carcass && (s = this.func_70673_aS()) != null) {
            this.func_85030_a(s, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
        this.isCarcass = carcass;
    }

    public boolean isCarcass() {
        return this.isCarcass;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (player.func_70093_af()) {
            if (this.getAgePercentage() > 75) {
                player.func_71007_a((IInventory)this.inventory);
            } else if (this.field_70170_p.field_72995_K) {
                String msg = this.func_145818_k_() ? this.func_95999_t() : "This " + this.func_70005_c_();
                player.func_146105_b((IChatComponent)new ChatComponentText(msg + " is not old enough to hold items!"));
            }
        } else {
            Item item;
            ItemStack heldItem = player.func_70694_bm();
            if (heldItem != null && (item = heldItem.func_77973_b()) instanceof ItemBluePrint) {
                ((ItemBluePrint)item).setDinosaur(heldItem, JCEntityRegistry.getDinosaurId(this.getDinosaur()));
            }
        }
        return false;
    }

    protected void addAIForAttackTargets(Class entity, int prio) {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, entity, 1.0, false));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, entity, false));
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getAgePercentage() < 50;
    }

    protected void defendFromAttacker(Class entity, int prio) {
        this.field_70715_bh.func_75776_a(prio, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{entity}));
    }

    public int getDNAQuality() {
        return this.geneticsQuality;
    }

    public void setDNAQuality(int quality) {
        this.geneticsQuality = quality;
    }

    @Override
    public void setAnimID(AnimID newAnimation) {
        JurassiCraft.instance.getLogger().debug("Setting anim id for entity " + this.func_145782_y() + " to " + (Object)((Object)newAnimation));
        if (newAnimation != this.animID) {
            this.animID = newAnimation;
        }
    }

    @Override
    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    @Override
    public AnimID getAnimID() {
        return this.animID;
    }

    @Override
    public int getAnimTick() {
        return this.animTick;
    }

    protected String randomSound(String ... sounds) {
        return "jurassicraft:" + sounds[this.field_70146_Z.nextInt(sounds.length)];
    }

    public double getAttackDamage() {
        return this.transitionFromAge(this.dinosaur.getBabyStrength(), this.dinosaur.getAdultStrength());
    }

    public boolean isStronger(EntityDinosaur dinosaur) {
        return this.func_110143_aJ() * (float)this.getAttackDamage() < dinosaur.func_110143_aJ() * (float)dinosaur.getAttackDamage();
    }

    public boolean isMale() {
        return this.isMale;
    }

    public void setMale(boolean male) {
        this.isMale = male;
    }

    public int getAgePercentage() {
        int age = this.getDinosaurAge();
        return age != 0 ? age * 100 / this.getDinosaur().getMaximumAge() : 0;
    }

    public int getOverlayR() {
        return this.genetics.getOverlayR();
    }

    public int getOverlayG() {
        return this.genetics.getOverlayG();
    }

    public int getOverlayB() {
        return this.genetics.getOverlayB();
    }

    public int getOverlay(int index) {
        switch (index) {
            case 0: {
                return this.genetics.getOverlay1();
            }
            case 1: {
                return this.genetics.getOverlay2();
            }
            case 2: {
                return this.genetics.getOverlay3();
            }
        }
        return -1;
    }

    public EnumGrowthStage getGrowthStage() {
        EnumGrowthStage stage = EnumGrowthStage.INFANT;
        int percent = this.getAgePercentage();
        if (percent > 75) {
            stage = EnumGrowthStage.ADULT;
        } else if (percent > 50) {
            stage = EnumGrowthStage.ADOLESCENT;
        } else if (percent > 25) {
            stage = EnumGrowthStage.JUVENILE;
        }
        return stage;
    }

    public void increaseGrowthSpeed() {
        this.growthSpeedOffset += 240;
    }

    public boolean isSwimming() {
        return this.func_70090_H() || this.func_180799_ab();
    }

    public String getCallSound() {
        return null;
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74780_a("DinosaurAge", (double)this.dinosaurAge);
        nbt.func_74757_a("IsCarcass", this.isCarcass);
        nbt.func_74768_a("DNAQuality", this.geneticsQuality);
        nbt.func_74778_a("Genetics", this.genetics.toString());
        nbt.func_74757_a("IsMale", this.isMale);
        nbt.func_74768_a("GrowthSpeedOffset", this.growthSpeedOffset);
        this.metabolism.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("OwnerUUID", this.owner.toString());
        }
        this.inventory.writeToNBT(nbt);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.dinosaurAge = nbt.func_74762_e("DinosaurAge");
        this.isCarcass = nbt.func_74767_n("IsCarcass");
        this.geneticsQuality = nbt.func_74762_e("DNAQuality");
        this.genetics = new GeneticsContainer(nbt.func_74779_i("Genetics"));
        this.isMale = nbt.func_74767_n("IsMale");
        this.growthSpeedOffset = nbt.func_74762_e("GrowthSpeedOffset");
        this.metabolism.readFromNBT(nbt);
        String ownerUUID = nbt.func_74779_i("OwnerUUID");
        if (ownerUUID != null && ownerUUID.length() > 0) {
            this.owner = UUID.fromString(ownerUUID);
        }
        this.inventory.readFromNBT(nbt);
        this.updateCreatureData();
        this.adjustHitbox();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.dinosaurAge);
        buffer.writeBoolean(this.isCarcass);
        buffer.writeInt(this.geneticsQuality);
        buffer.writeBoolean(this.isMale);
        buffer.writeInt(this.growthSpeedOffset);
        this.metabolism.writeSpawnData(buffer);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.genetics.toString());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.dinosaurAge = additionalData.readInt();
        this.isCarcass = additionalData.readBoolean();
        this.geneticsQuality = additionalData.readInt();
        this.isMale = additionalData.readBoolean();
        this.growthSpeedOffset = additionalData.readInt();
        this.metabolism.readSpawnData(additionalData);
        this.genetics = new GeneticsContainer(ByteBufUtils.readUTF8String((ByteBuf)additionalData));
        this.updateCreatureData();
        this.adjustHitbox();
    }

    public MetabolismContainer getMetabolism() {
        return this.metabolism;
    }

    public boolean setSleepLocation(BlockPos sleepLocation, boolean moveTo) {
        if (moveTo) {
            int x = sleepLocation.func_177958_n();
            int y = sleepLocation.func_177956_o();
            int z = sleepLocation.func_177952_p();
            return this.func_70661_as().func_75492_a((double)x, (double)y, (double)z, 1.0);
        }
        return true;
    }

    public boolean isSleeping() {
        return this.isSleeping;
    }

    public boolean shouldGoBackToSleep() {
        return this.goBackToSleep;
    }

    public void dontGoBackToSleep() {
        this.goBackToSleep = false;
    }
}

