/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.base;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.item.JCItemRegistry;

public class InventoryDinosaur
implements IInventory {
    private EntityDinosaur entity;
    private ItemStack[] inventory;

    public InventoryDinosaur(EntityDinosaur entity) {
        this.entity = entity;
        this.inventory = new ItemStack[entity.getDinosaur().getStorage()];
    }

    public boolean checkForTracker() {
        boolean hasTracker = false;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != JCItemRegistry.tracker) continue;
            hasTracker = true;
        }
        this.entity.setHasTracker(hasTracker);
        return hasTracker;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound slotTag = new NBTTagCompound();
            slotTag.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(slotTag);
            nbttaglist.func_74742_a((NBTBase)slotTag);
        }
        nbt.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound slotTag = nbttaglist.func_150305_b(i);
            int j = slotTag.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventory.length) continue;
            this.func_70299_a(j, ItemStack.func_77949_a((NBTTagCompound)slotTag));
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] != null) {
            if (this.inventory[index].field_77994_a <= count) {
                ItemStack itemstack = this.inventory[index];
                this.func_70299_a(index, null);
                return itemstack;
            }
            ItemStack itemstack = this.inventory[index].func_77979_a(count);
            if (this.inventory[index].field_77994_a == 0) {
                this.func_70299_a(index, null);
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.inventory[index] != null) {
            ItemStack itemstack = this.inventory[index];
            this.func_70299_a(index, null);
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        this.checkForTracker();
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !this.entity.field_70128_L && player.func_70068_e((Entity)this.entity) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }

    public String func_70005_c_() {
        return this.entity.func_70005_c_();
    }

    public boolean func_145818_k_() {
        return this.entity.func_145818_k_();
    }

    public IChatComponent func_145748_c_() {
        return this.entity.func_145748_c_();
    }

    public void dropItems(World worldObj, Random rand) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack == null) continue;
            float offsetX = rand.nextFloat() * 0.8f + 0.1f;
            float offsetY = rand.nextFloat() * 0.8f + 0.1f;
            float offsetZ = rand.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int j = rand.nextInt(21) + 10;
                if (j > itemstack.field_77994_a) {
                    j = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= j;
                EntityItem itemEntity = new EntityItem(worldObj, this.entity.field_70165_t + (double)offsetX, this.entity.field_70163_u + (double)offsetY, this.entity.field_70161_v + (double)offsetZ, new ItemStack(itemstack.func_77973_b(), j, itemstack.func_77952_i()));
                float multiplier = 0.05f;
                itemEntity.field_70159_w = (float)rand.nextGaussian() * multiplier;
                itemEntity.field_70181_x = (float)rand.nextGaussian() * multiplier + 0.2f;
                itemEntity.field_70179_y = (float)rand.nextGaussian() * multiplier;
                worldObj.func_72838_d((Entity)itemEntity);
            }
        }
    }
}

