/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.entity.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.jurassicraft.common.entity.data.JCPlayerDataClient;
import org.jurassicraft.common.genetics.DinoDNA;
import org.jurassicraft.common.paleopad.App;
import org.jurassicraft.common.paleopad.JCFile;

public class JCPlayerData
implements IExtendedEntityProperties {
    public static final String identifier = "JurassiCraftPlayerData";
    private boolean pressingSpace;
    private Map<String, NBTTagCompound> appdata = new HashMap<String, NBTTagCompound>();
    private List<App> openApps = new ArrayList<App>();
    private List<JCFile> rootFiles = new ArrayList<JCFile>();
    private List<BlockPos> cameras = new ArrayList<BlockPos>();
    private EntityPlayer player;

    public static JCPlayerData getPlayerData(EntityPlayer player) {
        return FMLCommonHandler.instance().getEffectiveSide().isClient() ? JCPlayerData.getPlayerDataClient() : (JCPlayerData)player.getExtendedProperties(identifier);
    }

    private static JCPlayerData getPlayerDataClient() {
        return JCPlayerDataClient.getPlayerData();
    }

    public static void setPlayerData(EntityPlayer player, NBTTagCompound nbt) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            JCPlayerData.setPlayerDataClient(nbt);
        } else {
            JCPlayerData.getPlayerData(player).loadNBTData(nbt);
        }
    }

    private static void setPlayerDataClient(NBTTagCompound nbt) {
        JCPlayerDataClient.updatePlayerData(nbt);
    }

    public void saveNBTData(NBTTagCompound playerData) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList files = new NBTTagList();
        for (JCFile jCFile : this.rootFiles) {
            if (jCFile == null) continue;
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            jCFile.writeToNBT(nBTTagCompound);
            files.func_74742_a((NBTBase)nBTTagCompound);
        }
        nbt.func_74782_a("Files", (NBTBase)files);
        NBTTagList appDataList = new NBTTagList();
        for (Map.Entry<String, NBTTagCompound> entry : this.appdata.entrySet()) {
            NBTTagCompound appData = new NBTTagCompound();
            appData.func_74778_a("Name", entry.getKey());
            appData.func_74782_a("Data", (NBTBase)entry.getValue());
            appDataList.func_74742_a((NBTBase)appData);
        }
        nbt.func_74782_a("JCAppData", (NBTBase)appDataList);
        NBTTagList nBTTagList = new NBTTagList();
        for (BlockPos pos : this.cameras) {
            NBTTagCompound camera = new NBTTagCompound();
            camera.func_74768_a("CamX", pos.func_177958_n());
            camera.func_74768_a("CamY", pos.func_177956_o());
            camera.func_74768_a("CamZ", pos.func_177952_p());
            nBTTagList.func_74742_a((NBTBase)camera);
        }
        nbt.func_74782_a("Cameras", (NBTBase)nBTTagList);
        playerData.func_74782_a("PaleoPadData", (NBTBase)nbt);
    }

    public void loadNBTData(NBTTagCompound playerData) {
        this.rootFiles.clear();
        this.appdata.clear();
        NBTTagCompound nbt = playerData.func_74775_l("PaleoPadData");
        NBTTagList filesList = nbt.func_150295_c("Files", 10);
        for (int i = 0; i < filesList.func_74745_c(); ++i) {
            NBTTagCompound fileTag = (NBTTagCompound)filesList.func_179238_g(i);
            this.rootFiles.add(JCFile.readFromNBT(fileTag, this.player, null));
        }
        NBTTagList appDataList = nbt.func_150295_c("JCAppData", 10);
        for (int i = 0; i < appDataList.func_74745_c(); ++i) {
            NBTTagCompound appData = (NBTTagCompound)appDataList.func_179238_g(i);
            this.appdata.put(appData.func_74779_i("Name"), appData.func_74775_l("Data"));
        }
        NBTTagList cameraList = nbt.func_150295_c("Cameras", 10);
        for (int i = 0; i < cameraList.func_74745_c(); ++i) {
            NBTTagCompound camera = (NBTTagCompound)cameraList.func_179238_g(i);
            this.cameras.add(new BlockPos(camera.func_74762_e("CamX"), camera.func_74762_e("CamY"), camera.func_74762_e("CamZ")));
        }
    }

    public void openApp(App app) {
        if (this.appdata.containsKey(app.getName())) {
            app.readAppFromNBT(this.appdata.get(app.getName()));
        }
        app.init();
        app.open();
        this.openApps.add(app);
    }

    public void closeApp(App app) {
        NBTTagCompound data = new NBTTagCompound();
        app.writeAppToNBT(data);
        this.appdata.put(app.getName(), data);
        this.openApps.remove(app);
    }

    public void addSequencedDNA(DinoDNA dna) {
        JCFile sequencedDNADir = this.getFile("Sequenced DNA", true);
        JCFile dnaFile = new JCFile(dna.toString(), sequencedDNADir, this.player, false);
        NBTTagCompound data = new NBTTagCompound();
        dna.writeToNBT(data);
        dnaFile.setData(data);
    }

    public void addCamera(BlockPos pos) {
        if (!this.cameras.contains(pos)) {
            this.cameras.add(pos);
        }
    }

    public List<BlockPos> getCameras() {
        return this.cameras;
    }

    public void init(Entity entity, World world) {
        if (entity instanceof EntityPlayer) {
            this.player = (EntityPlayer)entity;
        }
    }

    public JCFile getFileFromPath(String path) {
        if (path.length() == 0) {
            return null;
        }
        String[] pathSplit = path.split(Pattern.quote("/"));
        if (pathSplit.length == 0) {
            pathSplit = new String[]{path};
        }
        return this.traversePath(pathSplit, 1, this.getFile(pathSplit[0], true));
    }

    public List<JCFile> getFilesAtPath(String path) {
        if (path == null || path.length() == 0) {
            return this.rootFiles;
        }
        JCFile fileFromPath = this.getFileFromPath(path);
        if (fileFromPath == null) {
            return null;
        }
        return fileFromPath.getChildren();
    }

    public JCFile traversePath(String[] path, int i, JCFile lastFile) {
        if (i == path.length) {
            return lastFile;
        }
        for (JCFile child : lastFile.getChildren()) {
            if (!child.getName().equals(path[i])) continue;
            return this.traversePath(path, i + 1, child);
        }
        return null;
    }

    public JCFile getFile(String file, boolean dir) {
        JCFile jcFile = null;
        for (JCFile rFile : this.rootFiles) {
            if (rFile == null || !rFile.getName().equals(file)) continue;
            jcFile = rFile;
            break;
        }
        if (jcFile == null) {
            jcFile = new JCFile(file, null, this.player, dir);
            this.addRootFile(jcFile);
        }
        return jcFile;
    }

    public void addRootFile(JCFile jcFile) {
        if (jcFile.getParent() == null) {
            if (this.rootFiles.contains(jcFile)) {
                this.rootFiles.remove(jcFile);
            }
            this.rootFiles.add(jcFile);
        }
    }

    public void remove(JCFile file) {
        if (file.getParent() == null && this.rootFiles.contains(file)) {
            this.rootFiles.remove(file);
        }
    }

    public void clearRootFiles() {
        this.rootFiles.clear();
    }
}

