/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.genetics;

public class GeneticsContainer {
    private String genetics;
    public static final int DINOSAUR = 0;
    public static final int OVERLAY_R = 1;
    public static final int OVERLAY_G = 2;
    public static final int OVERLAY_B = 3;
    public static final int OVERLAY_1 = 4;
    public static final int OVERLAY_2 = 5;
    public static final int OVERLAY_3 = 6;
    private static final int VAR_COUNT = 6;

    public GeneticsContainer(String genetics) {
        this.genetics = genetics;
    }

    public GeneticsContainer(int dinosaur, int overlayR, int overlayG, int overlayB, int overlay1, int overlay2, int overlay3) {
        this.genetics = this.defaultGeneticCode();
        this.set(0, dinosaur);
        this.set(1, overlayR);
        this.set(2, overlayG);
        this.set(3, overlayB);
        this.set(4, overlay1);
        this.set(5, overlay2);
        this.set(6, overlay3);
    }

    private String defaultGeneticCode() {
        String code = "";
        for (int i = 0; i < 6; ++i) {
            code = code + "AAAA";
        }
        return code;
    }

    public int getDinosaur() {
        return this.get(0);
    }

    public int getOverlayR() {
        return this.get(1);
    }

    public int getOverlayG() {
        return this.get(2);
    }

    public int getOverlayB() {
        return this.get(3);
    }

    public int getOverlay1() {
        return this.get(4);
    }

    public int getOverlay2() {
        return this.get(5);
    }

    public int getOverlay3() {
        return this.get(6);
    }

    public int get(int id) {
        int charStart = id * 4;
        if (charStart >= 0 && charStart + 3 < this.genetics.length()) {
            return this.convert(this.genetics.charAt(charStart), this.genetics.charAt(charStart + 1), this.genetics.charAt(charStart + 2), this.genetics.charAt(charStart + 3));
        }
        return -1;
    }

    public void set(int id, int value) {
        int charStart = id * 4;
        if (charStart >= 0 && charStart + 3 < this.genetics.length()) {
            char[] chars = this.convert(value);
            StringBuilder sb = new StringBuilder(this.genetics);
            for (int i = 0; i < chars.length; ++i) {
                sb.setCharAt(i + charStart, chars[i]);
            }
            this.genetics = sb.toString();
        }
    }

    public int convert(char ... chars) {
        int value = 0;
        int i = 0;
        for (char c : chars) {
            if (c == 'C') {
                value = (int)((double)value + 1.0 * Math.pow(4.0, i));
            } else if (c == 'G') {
                value = (int)((double)value + 2.0 * Math.pow(4.0, i));
            } else if (c == 'T') {
                value = (int)((double)value + 3.0 * Math.pow(4.0, i));
            }
            ++i;
        }
        return value;
    }

    public char[] convert(int value) {
        char[] chars = new char[4];
        int next = value;
        int index = 0;
        while (next > 0) {
            int r = next % 4;
            next = (int)Math.floor(next / 4);
            switch (r) {
                case 0: {
                    chars[index] = 65;
                    break;
                }
                case 1: {
                    chars[index] = 67;
                    break;
                }
                case 2: {
                    chars[index] = 71;
                    break;
                }
                case 3: {
                    chars[index] = 84;
                }
            }
            ++index;
        }
        for (int i = index; i < 4; ++i) {
            chars[i] = 65;
        }
        return chars;
    }

    public String toString() {
        return this.genetics;
    }
}

