/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.message.HelicopterMessages;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;

public class MessageHelicopterEngine
implements IMessage {
    private int heliID;
    private boolean engineState;

    public MessageHelicopterEngine() {
    }

    public MessageHelicopterEngine(int heliID, boolean engineState) {
        this.heliID = heliID;
        this.engineState = engineState;
    }

    public void fromBytes(ByteBuf buf) {
        this.heliID = buf.readInt();
        this.engineState = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.heliID);
        buf.writeBoolean(this.engineState);
    }

    public static class Handler
    implements IMessageHandler<MessageHelicopterEngine, IMessage> {
        public IMessage onMessage(final MessageHelicopterEngine packet, final MessageContext ctx) {
            JurassiCraft.proxy.scheduleTask(ctx, new Runnable(){

                @Override
                public void run() {
                    World world = null;
                    world = ctx.side == Side.CLIENT ? Handler.this.getClientWorld() : ctx.getServerHandler().field_147369_b.field_70170_p;
                    EntityHelicopterBase helicopter = HelicopterMessages.getHeli(world, packet.heliID);
                    if (helicopter != null) {
                        helicopter.setEngineRunning(packet.engineState);
                    }
                }
            });
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private World getClientWorld() {
            return FMLClientHandler.instance().getWorldClient();
        }
    }
}

