/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.message.HelicopterMessages;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;
import org.jurassicraft.common.vehicles.helicopter.modules.EnumModulePosition;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModuleSpot;

public class MessageHelicopterModules
implements IMessage {
    private NBTTagCompound compound;
    private EnumModulePosition pos;
    private HelicopterModuleSpot spot;
    private int heliID;

    public MessageHelicopterModules() {
    }

    public MessageHelicopterModules(int heliID, EnumModulePosition pos, HelicopterModuleSpot spot) {
        this.heliID = heliID;
        this.pos = pos;
        this.spot = spot;
        this.compound = new NBTTagCompound();
        spot.writeToNBT(this.compound);
    }

    public void fromBytes(ByteBuf buf) {
        this.heliID = buf.readInt();
        this.pos = EnumModulePosition.values()[buf.readInt()];
        this.compound = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.heliID);
        buf.writeInt(this.pos.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
    }

    public static class Handler
    implements IMessageHandler<MessageHelicopterModules, IMessage> {
        public IMessage onMessage(final MessageHelicopterModules packet, final MessageContext ctx) {
            JurassiCraft.proxy.scheduleTask(ctx, new Runnable(){

                @Override
                public void run() {
                    World world = ctx.side == Side.CLIENT ? Handler.this.getClientWorld() : ctx.getServerHandler().field_147369_b.field_70170_p;
                    EntityHelicopterBase helicopter = HelicopterMessages.getHeli(world, packet.heliID);
                    if (helicopter != null) {
                        System.out.println(packet.heliID);
                        HelicopterModuleSpot spot = helicopter.getModuleSpot(packet.pos);
                        spot.readFromNBT(packet.compound);
                        System.out.println(packet.compound);
                    }
                }
            });
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private World getClientWorld() {
            return FMLClientHandler.instance().getWorldClient();
        }
    }
}

