/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.entity.item.EntityPaddockSign;

public class MessagePlacePaddockSign
implements IMessage {
    private int dino;
    private BlockPos pos;
    private EnumFacing facing;

    public MessagePlacePaddockSign() {
    }

    public MessagePlacePaddockSign(EnumFacing facing, BlockPos pos, Dinosaur dino) {
        this.dino = JCEntityRegistry.getDinosaurId(dino);
        this.pos = pos;
        this.facing = facing;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.pos.func_177986_g());
        buffer.writeInt(this.dino);
        buffer.writeByte((int)((byte)this.facing.func_176745_a()));
    }

    public void fromBytes(ByteBuf buffer) {
        this.pos = BlockPos.func_177969_a((long)buffer.readLong());
        this.dino = buffer.readInt();
        this.facing = EnumFacing.func_82600_a((int)buffer.readByte());
    }

    public static class Handler
    implements IMessageHandler<MessagePlacePaddockSign, IMessage> {
        public IMessage onMessage(final MessagePlacePaddockSign packet, final MessageContext ctx) {
            JurassiCraft.proxy.scheduleTask(ctx, new Runnable(){

                @Override
                public void run() {
                    if (ctx.side.isServer()) {
                        EntityPlayer player = JurassiCraft.proxy.getPlayerEntityFromContext(ctx);
                        World world = player.field_70170_p;
                        EnumFacing side = packet.facing;
                        BlockPos pos = packet.pos;
                        EntityPaddockSign paddockSign = new EntityPaddockSign(world, pos, side, packet.dino);
                        if (player.func_175151_a(pos, side, player.func_70694_bm()) && paddockSign.func_70518_d()) {
                            world.func_72838_d((Entity)paddockSign);
                            if (!player.field_71075_bZ.field_75098_d) {
                                InventoryPlayer inventory = player.field_71071_by;
                                inventory.func_70298_a(inventory.field_70461_c, 1);
                            }
                        }
                    }
                }
            });
            return null;
        }
    }
}

