/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.message;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.entity.data.JCPlayerData;
import org.jurassicraft.common.paleopad.JCFile;

public class MessageSendFile
implements IMessage {
    private JCFile file;
    private JCPlayerData playerData;
    private String path;
    private List<String> children = new ArrayList<String>();
    private NBTTagCompound data;
    private boolean isDir;

    public MessageSendFile() {
    }

    public MessageSendFile(JCPlayerData data, JCFile file) {
        this.file = file;
        this.playerData = data;
    }

    public void toBytes(ByteBuf buffer) {
        if (this.file == null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"");
            List<JCFile> children = this.playerData.getFilesAtPath("");
            int i = 0;
            for (JCFile child : children) {
                if (child == null) continue;
                ++i;
            }
            buffer.writeInt(i);
            for (JCFile child : children) {
                if (child == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)child.getName());
            }
        } else {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.file.getPath());
            List<JCFile> children = this.file.getChildren();
            int i = 0;
            for (JCFile child : children) {
                if (child == null) continue;
                ++i;
            }
            buffer.writeInt(i);
            buffer.writeBoolean(this.file.isDirectory());
            for (JCFile child : children) {
                if (child == null) continue;
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)child.getName());
            }
            if (this.file.isFile() && this.file.getData() != null) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)this.file.getData());
            }
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.path = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (this.path.length() > 0) {
            int childCount = buffer.readInt();
            this.isDir = buffer.readBoolean();
            for (int i = 0; i < childCount; ++i) {
                String childName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.children.add(childName);
            }
            if (!this.isDir) {
                this.data = ByteBufUtils.readTag((ByteBuf)buffer);
            }
        } else {
            int childCount = buffer.readInt();
            this.isDir = true;
            for (int i = 0; i < childCount; ++i) {
                String childName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
                this.children.add(childName);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<MessageSendFile, IMessage> {
        public IMessage onMessage(final MessageSendFile packet, final MessageContext ctx) {
            JurassiCraft.proxy.scheduleTask(ctx, new Runnable(){

                @Override
                public void run() {
                    block5: {
                        block4: {
                            if (!ctx.side.isClient()) break block4;
                            JCFile file = JCPlayerData.getPlayerData(null).getFileFromPath(packet.path);
                            if (!packet.isDir) {
                                file.setData(packet.data);
                            }
                            for (String child : packet.children) {
                                new JCFile(child, file, JurassiCraft.proxy.getPlayer(), packet.isDir);
                            }
                            break block5;
                        }
                        EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                        if (player == null) break block5;
                        JCFile file = JCPlayerData.getPlayerData((EntityPlayer)player).getFileFromPath(packet.path);
                        if (!packet.isDir) {
                            file.setData(packet.data);
                        }
                        for (String child : packet.children) {
                            new JCFile(child, file, (EntityPlayer)player, packet.isDir);
                        }
                    }
                }
            });
            return null;
        }
    }
}

