/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.period;

import net.minecraft.util.IStringSerializable;

public enum EnumTimePeriod implements IStringSerializable
{
    QUATERNARY(0, "quaternary", 2.588f, 0.0f, false),
    NEOGENE(1, "neogene", 23.03f, 2.589f, false),
    PALEOGENE(2, "paleogene", 66.0f, 23.04f, false),
    CRETACEOUS(3, "cretaceous", 145.5f, 66.1f, true),
    JURASSIC(4, "jurassic", 201.3f, 145.6f, false),
    TRIASSIC(5, "triassic", 252.17f, 201.4f, false),
    PERMIAN(6, "permian", 298.9f, 252.18f, false),
    CARBONIFEROUS(7, "carboniferous", 358.9f, 299.0f, false),
    DEVONIAN(8, "devonian", 419.2f, 359.0f, false),
    SILURIAN(9, "silurian", 443.4f, 419.3f, false),
    ORDOVICIAN(10, "ordovician", 485.4f, 443.5f, false),
    CAMBRIAN(11, "cambrian", 541.0f, 485.5f, false);

    private final String name;
    private final int meta;
    private final float startTime;
    private final float endTime;
    private final boolean shouldImplement;
    private static final EnumTimePeriod[] META_LOOKUP;

    public int getMetadata() {
        return this.meta;
    }

    public String toString() {
        return this.name;
    }

    public static EnumTimePeriod byMetadata(int meta) {
        if (meta < 0 || meta >= META_LOOKUP.length) {
            meta = 0;
        }
        return META_LOOKUP[meta];
    }

    public String func_176610_l() {
        return this.name;
    }

    public float getStartTime() {
        return this.startTime;
    }

    public float getEndTime() {
        return this.endTime;
    }

    public String getNameForDisplay() {
        return this.name;
    }

    public boolean shouldBeImplement() {
        return this.shouldImplement;
    }

    private EnumTimePeriod(int meta, String name, float startTime, float endTime, boolean shouldImplement) {
        this.name = name;
        this.meta = meta;
        this.startTime = startTime;
        this.endTime = endTime;
        this.shouldImplement = shouldImplement;
    }

    public static int getStartYLevel(EnumTimePeriod period) {
        return 64 - (int)(period.getStartTime() != 0.0f ? period.getStartTime() * 64.0f / 541.0f : 0.0f);
    }

    public static int getEndYLevel(EnumTimePeriod period) {
        return 64 - (int)(period.getEndTime() != 0.0f ? period.getEndTime() * 64.0f / 541.0f : 0.0f);
    }

    static {
        META_LOOKUP = new EnumTimePeriod[EnumTimePeriod.values().length];
        EnumTimePeriod[] enumTimePeriodArray = EnumTimePeriod.values();
        int n = enumTimePeriodArray.length;
        for (int i = 0; i < n; ++i) {
            EnumTimePeriod timePeriod;
            EnumTimePeriod.META_LOOKUP[timePeriod.getMetadata()] = timePeriod = enumTimePeriodArray[i];
        }
    }
}

