/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.recipe;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.jurassicraft.common.block.JCBlockRegistry;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.paleopad.dinopedia.DinoPediaRegistry;

public class JCRecipeRegistry {
    public void register() {
        for (Dinosaur dinosaur : JCEntityRegistry.getDinosaurs()) {
            if (!dinosaur.shouldRegister()) continue;
            int meta = JCEntityRegistry.getDinosaurId(dinosaur);
            GameRegistry.addSmelting((ItemStack)new ItemStack((Item)JCItemRegistry.dino_meat, 1, meta), (ItemStack)new ItemStack((Item)JCItemRegistry.dino_steak, 1, meta), (float)5.0f);
        }
        int i = 0;
        for (Block block : JCBlockRegistry.planks) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(block, 4), (Object[])new Object[]{JCBlockRegistry.woods[i]});
            this.addRecipe(new ItemStack(JCBlockRegistry.stairs[i], 4), "w  ", "ww ", "www", Character.valueOf('w'), block);
            this.addRecipe(new ItemStack(JCBlockRegistry.stairs[i], 4), "  w", " ww", "www", Character.valueOf('w'), block);
            this.addRecipe(new ItemStack(JCBlockRegistry.slabs[i], 6), "www", Character.valueOf('w'), block);
            ++i;
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(JCBlockRegistry.gypsum_cobblestone), (ItemStack)new ItemStack(JCBlockRegistry.gypsum_stone), (float)1.5f);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.iron_blades), "I I", " S ", "I I", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), Items.field_151055_y);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.iron_rod), "ISI", "ISI", "ISI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), Items.field_151055_y);
        this.addRecipe(new ItemStack(JCBlockRegistry.fossil_grinder), new Object[]{"lBl", "rRr", "IPI", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), JCItemRegistry.iron_rod, Character.valueOf('B'), JCItemRegistry.iron_blades, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('l'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('P'), Blocks.field_150331_J});
        this.addRecipe(new ItemStack((Item)JCItemRegistry.plaster_and_bandage, 9), "PPP", "PWP", "PPP", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('W'), Blocks.field_150325_L);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.cage_small, 1), "III", "BBB", "III", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150411_aY);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.cage_small, 1, 1), "III", "GBG", "III", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('B'), Items.field_151131_as);
        this.addRecipe(new ItemStack(JCBlockRegistry.gypsum_bricks, 4), "SS", "SS", Character.valueOf('S'), JCBlockRegistry.gypsum_stone);
        this.addRecipe(new ItemStack(JCBlockRegistry.cleaning_station), "iii", "RGR", "IBI", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('I'), Blocks.field_150339_S);
        this.addRecipe(new ItemStack(JCBlockRegistry.reinforced_stone, 8), "PPP", "PWP", "PPP", Character.valueOf('P'), Blocks.field_150348_b, Character.valueOf('W'), Items.field_151042_j);
        this.addRecipe(new ItemStack(JCBlockRegistry.reinforced_bricks, 8), "PPP", "PWP", "PPP", Character.valueOf('P'), Blocks.field_150417_aV, Character.valueOf('W'), Items.field_151042_j);
        this.addRecipe(new ItemStack(JCBlockRegistry.reinforced_bricks, 4), "SS", "SS", Character.valueOf('S'), JCBlockRegistry.reinforced_stone);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.empty_test_tube), "I", "G", "G", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('I'), Items.field_151042_j);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.petri_dish), "G G", "GGG", Character.valueOf('G'), Blocks.field_150410_aZ);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.blue_print), "BBB", "BPB", "BBB", Character.valueOf('B'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('P'), Items.field_151121_aF);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.empty_syringe), new Object[]{"  N", "IG ", "II ", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('N'), JCItemRegistry.needle});
        this.addRecipe(new ItemStack((Item)JCItemRegistry.empty_syringe), new Object[]{"N  ", " GI", " II", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('N'), JCItemRegistry.needle});
        GameRegistry.addSmelting((ItemStack)new ItemStack((Item)Items.field_151068_bn, 1, 0), (ItemStack)new ItemStack((Item)JCItemRegistry.dna_base), (float)1.0f);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.needle), "GIG", "GIG", " I ", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('I'), Items.field_151042_j);
        this.addRecipe(new ItemStack(JCBlockRegistry.dna_extractor), new Object[]{"III", "INI", "RSR", Character.valueOf('S'), JCBlockRegistry.dna_sequencer, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('N'), JCItemRegistry.needle});
        this.addRecipe(new ItemStack(JCBlockRegistry.dna_sequencer), new Object[]{"RDR", "GNG", "III", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('N'), JCItemRegistry.needle, Character.valueOf('D'), JCItemRegistry.disc_reader, Character.valueOf('R'), Items.field_151137_ax});
        this.addRecipe(new ItemStack(JCBlockRegistry.dna_synthesizer), new Object[]{"GDG", "RBR", "ITI", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), JCItemRegistry.disc_reader});
        for (i = 0; i < 16; ++i) {
            this.addRecipe(new ItemStack(JCBlockRegistry.cultivate_bottom, 1, i), "GGG", "GWG", "III", Character.valueOf('G'), new ItemStack((Block)Blocks.field_150397_co, 1, i), Character.valueOf('W'), Items.field_151131_as, Character.valueOf('I'), Items.field_151042_j);
        }
        this.addRecipe(new ItemStack(JCBlockRegistry.embryonic_machine), "GIG", "GIG", "III", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('I'), Items.field_151042_j);
        this.addRecipe(new ItemStack(JCBlockRegistry.embryo_calcification_machine), new Object[]{"GIG", "GSG", "III", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), JCItemRegistry.needle});
        this.addRecipe(new ItemStack(JCBlockRegistry.incubator), "GGG", "RRR", "III", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('G'), Blocks.field_150359_w);
        this.addRecipe(new ItemStack(JCBlockRegistry.dna_combinator), new Object[]{"IDI", "GRG", "III", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), JCItemRegistry.disc_reader});
        this.addRecipe(new ItemStack(JCBlockRegistry.dna_hybridizer), "IRI", "GIG", "IRI", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.laser), "PRP", "ILI", "IGI", Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('P'), Items.field_151107_aW, Character.valueOf('L'), Blocks.field_150379_bu);
        this.addRecipe(new ItemStack((Item)JCItemRegistry.disc_reader), new Object[]{"ILI", "RNR", "TPT", Character.valueOf('N'), JCItemRegistry.needle, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('L'), JCItemRegistry.laser, Character.valueOf('P'), Blocks.field_150331_J});
        this.addRecipe(new ItemStack((Item)JCItemRegistry.storage_disc), "III", "IGI", "III", Character.valueOf('G'), Items.field_151043_k, Character.valueOf('I'), Items.field_151042_j);
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)JCItemRegistry.plant_cells_petri_dish), (Object[])new Object[]{JCItemRegistry.plant_cells, JCItemRegistry.petri_dish});
        this.addGrowthSerumRecipe(Items.field_151083_be);
        this.addGrowthSerumRecipe(Items.field_151077_bg);
        this.addGrowthSerumRecipe(Items.field_179566_aV);
        this.addGrowthSerumRecipe(Items.field_179557_bn);
        this.addGrowthSerumRecipe(Items.field_151157_am);
        this.addGrowthSerumRecipe(Items.field_179559_bp);
        for (i = 0; i < JCEntityRegistry.getDinosaurs().size(); ++i) {
            this.addGrowthSerumRecipe(new ItemStack((Item)JCItemRegistry.dino_steak, 1, i));
        }
    }

    private void addRecipe(ItemStack stack, Object ... pars) {
        GameRegistry.addRecipe((ItemStack)stack, (Object[])pars);
        this.getShapedRecipe(stack, pars);
        DinoPediaRegistry.addItemRecipe(stack, (IRecipe)this.getShapedRecipe(stack, pars));
    }

    private ShapedRecipes getShapedRecipe(ItemStack stack, Object[] pars) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (pars[i] instanceof String[]) {
            String[] astring;
            for (String s1 : astring = (String[])pars[i++]) {
                ++k;
                j = s1.length();
                s = s + s1;
            }
        } else {
            while (pars[i] instanceof String) {
                String s2 = (String)pars[i++];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        }
        HashMap hashmap = Maps.newHashMap();
        while (i < pars.length) {
            Character character = (Character)pars[i];
            ItemStack characterStack = null;
            if (pars[i + 1] instanceof Item) {
                characterStack = new ItemStack((Item)pars[i + 1]);
            } else if (pars[i + 1] instanceof Block) {
                characterStack = new ItemStack((Block)pars[i + 1], 1, Short.MAX_VALUE);
            } else if (pars[i + 1] instanceof ItemStack) {
                characterStack = (ItemStack)pars[i + 1];
            }
            hashmap.put(character, characterStack);
            i += 2;
        }
        ItemStack[] inputs = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char character = s.charAt(i1);
            inputs[i1] = hashmap.containsKey(Character.valueOf(character)) ? ((ItemStack)hashmap.get(Character.valueOf(character))).func_77946_l() : null;
        }
        return new ShapedRecipes(j, k, inputs, stack);
    }

    private void addGrowthSerumRecipe(Item meat) {
        this.addGrowthSerumRecipe(new ItemStack(meat));
    }

    private void addGrowthSerumRecipe(ItemStack meat) {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Item)JCItemRegistry.growth_serum), (Object[])new Object[]{Items.field_151150_bK, JCItemRegistry.empty_syringe, Items.field_151131_as, meat});
    }
}

