/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jurassicraft.common.container.ContainerDNACombinator;
import org.jurassicraft.common.genetics.DinoDNA;
import org.jurassicraft.common.genetics.PlantDNA;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.tileentity.TileMachineBase;

public class TileDNACombinator
extends TileMachineBase {
    private int[] inputs = new int[]{0, 1};
    private int[] outputs = new int[]{2};
    private ItemStack[] slots = new ItemStack[3];

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    @Override
    protected boolean canProcess(int process) {
        return this.slots[0] != null && this.slots[0].func_77973_b() == JCItemRegistry.storage_disc && this.slots[1] != null && this.slots[1].func_77973_b() == JCItemRegistry.storage_disc && this.slots[0].func_77978_p() != null && this.slots[1].func_77978_p() != null && this.slots[2] == null && this.slots[0].func_77952_i() == this.slots[1].func_77952_i() && this.slots[0].func_77978_p().func_74779_i("StorageId").equals(this.slots[1].func_77978_p().func_74779_i("StorageId"));
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            ItemStack output = new ItemStack((Item)JCItemRegistry.storage_disc, 1, this.slots[0].func_77952_i());
            String storageId = this.slots[0].func_77978_p().func_74779_i("StorageId");
            if (storageId.equals("DinoDNA")) {
                DinoDNA dna1 = DinoDNA.readFromNBT(this.slots[0].func_77978_p());
                DinoDNA dna2 = DinoDNA.readFromNBT(this.slots[1].func_77978_p());
                int newQuality = dna1.getDNAQuality() + dna2.getDNAQuality();
                if (newQuality > 100) {
                    newQuality = 100;
                }
                DinoDNA newDNA = new DinoDNA(newQuality, dna1.toString());
                NBTTagCompound outputTag = new NBTTagCompound();
                newDNA.writeToNBT(outputTag);
                output.func_77982_d(outputTag);
            } else if (storageId.equals("PlantDNA")) {
                PlantDNA dna1 = PlantDNA.readFromNBT(this.slots[0].func_77978_p());
                PlantDNA dna2 = PlantDNA.readFromNBT(this.slots[1].func_77978_p());
                int newQuality = dna1.getDNAQuality() + dna2.getDNAQuality();
                if (newQuality > 100) {
                    newQuality = 100;
                }
                PlantDNA newDNA = new PlantDNA(dna1.getPlant(), newQuality);
                NBTTagCompound outputTag = new NBTTagCompound();
                newDNA.writeToNBT(outputTag);
                output.func_77982_d(outputTag);
            }
            this.mergeStack(2, output);
            this.decreaseStackSize(0);
            this.decreaseStackSize(1);
        }
    }

    @Override
    protected int getMainInput(int process) {
        return 0;
    }

    @Override
    protected int getMainOutput(int process) {
        return 2;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 400;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return this.inputs;
    }

    @Override
    protected int[] getOutputs() {
        return this.outputs;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDNACombinator(playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_combinator";
    }

    public String getName() {
        return this.func_145818_k_() ? this.customName : "container.dna_combinator";
    }

    public String func_70005_c_() {
        return this.getName();
    }
}

