/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.common.api.IHybrid;
import org.jurassicraft.common.container.ContainerDNAHybridizer;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.genetics.DinoDNA;
import org.jurassicraft.common.genetics.GeneticsContainer;
import org.jurassicraft.common.item.ItemStorageDisc;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.tileentity.TileMachineBase;

public class TileDNAHybridizer
extends TileMachineBase {
    private int[] inputs = new int[]{0, 1, 2, 3, 4, 5};
    private int[] outputs = new int[]{6};
    private ItemStack[] slots = new ItemStack[7];

    @Override
    protected int getProcess(int slot) {
        return 0;
    }

    private Dinosaur getHybrid() {
        return this.getHybrid(this.slots[0], this.slots[1], this.slots[2], this.slots[3], this.slots[4], this.slots[5]);
    }

    private Dinosaur getHybrid(ItemStack baseDino1Disc, ItemStack baseDino2Disc, ItemStack extraDNA1Disc, ItemStack extraDNA2Disc, ItemStack extraDNA3Disc, ItemStack extraDNA4Disc) {
        Dinosaur hybrid = null;
        Dinosaur baseGene1 = this.getDino(baseDino1Disc);
        Dinosaur baseGene2 = this.getDino(baseDino2Disc);
        Dinosaur extraGene1 = this.getDino(extraDNA1Disc);
        Dinosaur extraGene2 = this.getDino(extraDNA2Disc);
        Dinosaur extraGene3 = this.getDino(extraDNA3Disc);
        Dinosaur extraGene4 = this.getDino(extraDNA4Disc);
        Dinosaur[] baseGenes = new Dinosaur[]{baseGene1, baseGene2};
        Dinosaur[] extraGenes = new Dinosaur[]{extraGene1, extraGene2, extraGene3, extraGene4};
        for (Dinosaur dino : JCEntityRegistry.getDinosaurs()) {
            boolean hasExtras;
            if (!(dino instanceof IHybrid)) continue;
            IHybrid dinoHybrid = (IHybrid)((Object)dino);
            int baseCount = 0;
            for (Class combo : dinoHybrid.getBaseGenes()) {
                if (!combo.isInstance(baseGene1) && !combo.isInstance(baseGene2)) continue;
                ++baseCount;
            }
            int count = 0;
            boolean extra = false;
            for (Dinosaur combo : extraGenes) {
                Class match = null;
                for (Class clazz : dinoHybrid.getExtraGenes()) {
                    if (!clazz.isInstance(combo)) continue;
                    match = clazz;
                }
                if (match != null && match.isInstance(combo)) {
                    ++count;
                    continue;
                }
                if (combo == null) continue;
                extra = true;
            }
            boolean hasBases = baseCount == dinoHybrid.getBaseGenes().length;
            boolean bl = hasExtras = !extra && count == dinoHybrid.getExtraGenes().length;
            if (!hasBases || !hasExtras) continue;
            hybrid = dino;
            break;
        }
        return hybrid;
    }

    private Dinosaur getDino(ItemStack disc) {
        if (disc != null) {
            DinoDNA data = DinoDNA.readFromNBT(disc.func_77978_p());
            return data.getDNAQuality() == 100 ? JCEntityRegistry.getDinosaurById(data.getContainer().getDinosaur()) : null;
        }
        return null;
    }

    @Override
    protected boolean canProcess(int process) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemStorageDisc && this.slots[1] != null && this.slots[1].func_77973_b() instanceof ItemStorageDisc) {
            return this.getHybrid() != null;
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            Dinosaur hybrid = this.getHybrid();
            NBTTagCompound nbt = new NBTTagCompound();
            int dinosaurId = JCEntityRegistry.getDinosaurId(hybrid);
            GeneticsContainer container = new GeneticsContainer(this.slots[0].func_77978_p().func_74779_i("Genetics"));
            container.set(0, dinosaurId);
            DinoDNA dna = new DinoDNA(100, container.toString());
            dna.writeToNBT(nbt);
            ItemStack output = new ItemStack((Item)JCItemRegistry.storage_disc, 1, dinosaurId);
            output.func_77964_b(dna.getContainer().getDinosaur());
            output.func_77982_d(nbt);
            this.mergeStack(6, output);
            for (int i = 0; i < 6; ++i) {
                this.decreaseStackSize(i);
            }
        }
    }

    @Override
    protected int getMainInput(int process) {
        return 0;
    }

    @Override
    protected int getMainOutput(int process) {
        return 6;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 1000;
    }

    @Override
    protected int getProcessCount() {
        return 1;
    }

    @Override
    protected int[] getInputs() {
        return this.inputs;
    }

    @Override
    protected int[] getOutputs() {
        return this.outputs;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDNAHybridizer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_hybridizer";
    }

    public String getName() {
        return this.func_145818_k_() ? this.customName : "container.dna_hybridizer";
    }

    public String func_70005_c_() {
        return this.getName();
    }
}

