/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import org.jurassicraft.common.container.ContainerDNASequencer;
import org.jurassicraft.common.genetics.DinoDNA;
import org.jurassicraft.common.genetics.GeneticsHelper;
import org.jurassicraft.common.item.ItemSoftTissue;
import org.jurassicraft.common.item.JCItemRegistry;
import org.jurassicraft.common.tileentity.TileMachineBase;

public class TileDnaSequencer
extends TileMachineBase {
    private int[] inputs = new int[]{0, 1, 2, 3, 4, 5};
    private int[] outputs = new int[]{6, 7, 8};
    private ItemStack[] slots = new ItemStack[9];

    @Override
    protected int getProcess(int slot) {
        return (int)Math.floor(slot / 2);
    }

    @Override
    protected boolean canProcess(int process) {
        int tissue = process * 2;
        ItemStack input = this.slots[tissue];
        ItemStack storage = this.slots[tissue + 1];
        if (input != null && input.func_77973_b() instanceof ItemSoftTissue && storage != null && storage.func_77973_b() == JCItemRegistry.storage_disc) {
            ItemStack output = new ItemStack((Item)JCItemRegistry.storage_disc, 1, input.func_77952_i());
            output.func_77982_d(input.func_77978_p());
            if (this.slots[process + 6] == null || ItemStack.func_179545_c((ItemStack)this.slots[process + 6], (ItemStack)output) && ItemStack.func_77970_a((ItemStack)this.slots[process + 6], (ItemStack)output)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void processItem(int process) {
        if (this.canProcess(process)) {
            NBTTagCompound nbt;
            Random rand = new Random();
            int tissue = process * 2;
            int quality = rand.nextInt(25) + 1;
            if (rand.nextDouble() < 0.1) {
                quality += 25;
                if (rand.nextDouble() < 0.1) {
                    quality += 25;
                    if (rand.nextDouble() < 0.1) {
                        quality += 25;
                    }
                }
            }
            if ((nbt = this.slots[tissue + 1].func_77978_p()) == null) {
                nbt = new NBTTagCompound();
            }
            DinoDNA dna = new DinoDNA(quality, GeneticsHelper.randomGenetics(rand, this.slots[tissue].func_77952_i(), quality).toString());
            dna.writeToNBT(nbt);
            ItemStack output = new ItemStack((Item)JCItemRegistry.storage_disc, 1, this.slots[tissue].func_77952_i());
            output.func_77964_b(dna.getContainer().getDinosaur());
            output.func_77982_d(nbt);
            this.mergeStack(process + 6, output);
            this.decreaseStackSize(tissue);
            this.decreaseStackSize(tissue + 1);
        }
    }

    @Override
    protected int getMainInput(int process) {
        return process * 2;
    }

    @Override
    protected int getMainOutput(int process) {
        return process * 2 + 1;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 2000;
    }

    @Override
    protected int getProcessCount() {
        return 3;
    }

    @Override
    protected int[] getInputs() {
        return this.inputs;
    }

    @Override
    protected int[] getOutputs() {
        return this.outputs;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDNASequencer(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:dna_sequencer";
    }

    public String getName() {
        return this.func_145818_k_() ? this.customName : "container.dna_sequencer";
    }

    public String func_70005_c_() {
        return this.getName();
    }
}

