/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import org.jurassicraft.common.container.ContainerIncubator;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.EntityDinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.entity.item.EntityCageSmall;
import org.jurassicraft.common.item.ItemDinosaurEgg;
import org.jurassicraft.common.tileentity.TileMachineBase;

public class TileIncubator
extends TileMachineBase {
    private int[] inputs = new int[]{0, 1, 2, 3, 4};
    private int[] other = new int[5];
    private int[] outputs = new int[0];
    private int[] temperature = new int[5];
    private ItemStack[] slots = new ItemStack[6];

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            this.temperature[i] = compound.func_74765_d("Temperature" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.func_74777_a("Temperature" + i, (short)this.temperature[i]);
        }
    }

    @Override
    protected int getProcess(int slot) {
        return slot;
    }

    @Override
    protected boolean canProcess(int process) {
        return this.slots[process] != null && this.slots[process].field_77994_a > 0 && this.slots[process].func_77973_b() instanceof ItemDinosaurEgg;
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.getInputs() : this.other;
    }

    @Override
    protected void processItem(int process) {
        ItemStack egg;
        Dinosaur dinoInEgg;
        if (this.canProcess(process) && !this.field_145850_b.field_72995_K && (dinoInEgg = JCEntityRegistry.getDinosaurById((egg = this.slots[process]).func_77960_j())) != null) {
            Class<? extends EntityDinosaur> dinoClass = dinoInEgg.getDinosaurClass();
            try {
                EntityDinosaur dino = dinoClass.getConstructor(World.class).newInstance(this.field_145850_b);
                dino.setDNAQuality(egg.func_77978_p().func_74762_e("DNAQuality"));
                dino.setGenetics(egg.func_77978_p().func_74779_i("Genetics"));
                dino.setMale(this.temperature[process] > 50);
                dino.setAge(0);
                int blockX = this.field_174879_c.func_177958_n();
                int blockY = this.field_174879_c.func_177956_o();
                int blockZ = this.field_174879_c.func_177952_p();
                List cages = this.field_145850_b.func_72872_a(EntityCageSmall.class, AxisAlignedBB.func_178781_a((double)(blockX - 2), (double)blockY, (double)(blockZ - 2), (double)(blockX + 2), (double)(blockY + 1), (double)(blockZ + 2)));
                EntityCageSmall cage = null;
                for (EntityCageSmall cCage : cages) {
                    if (cCage.getEntity() != null) continue;
                    cage = cCage;
                    break;
                }
                if (cage != null) {
                    cage.setEntity((Entity)dino);
                } else {
                    dino.func_70012_b(blockX + 2, (double)blockY + 0.5, blockZ + 2, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    dino.field_70759_as = dino.field_70177_z;
                    dino.field_70761_aq = dino.field_70177_z;
                    this.field_145850_b.func_72838_d((Entity)dino);
                }
                this.decreaseStackSize(process);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected int getMainInput(int process) {
        return process;
    }

    @Override
    protected int getMainOutput(int process) {
        return 0;
    }

    @Override
    protected int getStackProcessTime(ItemStack stack) {
        return 8000;
    }

    @Override
    protected int getProcessCount() {
        return 5;
    }

    @Override
    protected int[] getInputs() {
        return this.inputs;
    }

    @Override
    protected int[] getOutputs() {
        return this.outputs;
    }

    @Override
    protected ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    protected void setSlots(ItemStack[] slots) {
        this.slots = slots;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerIncubator(playerInventory, (TileEntity)this);
    }

    public String func_174875_k() {
        return "jurassicraft:incubator";
    }

    public String getName() {
        return this.func_145818_k_() ? this.customName : "container.incubator";
    }

    @Override
    public int func_174887_a_(int id) {
        if (id < 5) {
            return this.processTime[id];
        }
        if (id < 10) {
            return this.totalProcessTime[id - 5];
        }
        if (id < 15) {
            return this.temperature[id - 10];
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id < 5) {
            this.processTime[id] = value;
        } else if (id < 10) {
            this.totalProcessTime[id - 5] = value;
        } else if (id < 15) {
            this.temperature[id - 10] = value;
        }
    }

    public String func_70005_c_() {
        return this.getName();
    }
}

