/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileMachineBase
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    protected String customName;
    protected int[] processTime = new int[this.getProcessCount()];
    protected int[] totalProcessTime = new int[this.getProcessCount()];

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        super.func_145839_a(compound);
        NBTTagList itemList = compound.func_150295_c("Items", 10);
        ItemStack[] slots = new ItemStack[this.getSlots().length];
        for (i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound item = itemList.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= slots.length) continue;
            slots[slot] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        for (i = 0; i < this.getProcessCount(); ++i) {
            this.processTime[i] = compound.func_74765_d("ProcessTime" + i);
            this.totalProcessTime[i] = compound.func_74765_d("ProcessTimeTotal" + i);
        }
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.setSlots(slots);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        for (int i = 0; i < this.getProcessCount(); ++i) {
            compound.func_74777_a("ProcessTime" + i, (short)this.processTime[i]);
            compound.func_74777_a("ProcessTimeTotal" + i, (short)this.totalProcessTime[i]);
        }
        ItemStack[] slots = this.getSlots();
        NBTTagList itemList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (slots[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)slot);
            slots[slot].func_77955_b(itemTag);
            itemList.func_74742_a((NBTBase)itemTag);
        }
        compound.func_74782_a("Items", (NBTBase)itemList);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
    }

    public ItemStack func_70301_a(int index) {
        return this.getSlots()[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack[] slots = this.getSlots();
        if (slots[index] != null) {
            if (slots[index].field_77994_a <= count) {
                ItemStack stack = slots[index];
                slots[index] = null;
                return stack;
            }
            ItemStack stack = slots[index].func_77979_a(count);
            if (slots[index].field_77994_a == 0) {
                slots[index] = null;
            }
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack[] slots = this.getSlots();
        if (slots[index] != null) {
            ItemStack itemstack = slots[index];
            slots[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack[] slots = this.getSlots();
        boolean flag = stack != null && stack.func_77969_a(slots[index]) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slots[index]);
        slots[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (index < this.getInputs().length && !flag) {
            int i = this.getProcess(index);
            this.totalProcessTime[i] = this.getStackProcessTime(stack);
            this.processTime[i] = 0;
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    private boolean isInput(int slot) {
        int[] inputs = this.getInputs();
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != slot) continue;
            return true;
        }
        return false;
    }

    private boolean isOutput(int slot) {
        int[] outputs = this.getOutputs();
        for (int i = 0; i < outputs.length; ++i) {
            if (outputs[i] != slot) continue;
            return true;
        }
        return false;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomInventoryName(String customName) {
        this.customName = customName;
    }

    public int func_70302_i_() {
        return this.getSlots().length;
    }

    public boolean isProcessing(int index) {
        return this.processTime[index] > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isProcessing(IInventory inventory, int index) {
        return inventory.func_174887_a_(index) > 0;
    }

    public void func_73660_a() {
        ItemStack[] slots = this.getSlots();
        for (int i = 0; i < this.getProcessCount(); ++i) {
            boolean flag = this.isProcessing(i);
            boolean sync = false;
            if (!this.field_145850_b.field_72995_K) {
                if (!this.isProcessing(i) && slots[this.getMainInput(i)] == null) {
                    if (!this.isProcessing(i) && this.processTime[i] > 0) {
                        this.processTime[i] = MathHelper.func_76125_a((int)(this.processTime[i] - 2), (int)0, (int)this.totalProcessTime[i]);
                    }
                } else if (this.canProcess(i)) {
                    int n = i;
                    this.processTime[n] = this.processTime[n] + 1;
                    if (this.processTime[i] == this.totalProcessTime[i]) {
                        this.processTime[i] = 0;
                        this.totalProcessTime[i] = this.getStackProcessTime(slots[this.getMainInput(i)]);
                        this.processItem(i);
                        sync = true;
                    }
                } else {
                    this.processTime[i] = 0;
                    sync = true;
                }
                if (flag != this.isProcessing(i)) {
                    sync = true;
                }
            } else if (this.canProcess(i)) {
                int n = i;
                this.processTime[n] = this.processTime[n] + 1;
            }
            if (!sync) continue;
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return !this.isOutput(index);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? this.getOutputs() : this.getOutputs();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    protected abstract int getProcess(int var1);

    protected abstract boolean canProcess(int var1);

    protected abstract void processItem(int var1);

    protected abstract int getMainInput(int var1);

    protected abstract int getMainOutput(int var1);

    protected abstract int getStackProcessTime(ItemStack var1);

    protected abstract int getProcessCount();

    protected abstract int[] getInputs();

    protected abstract int[] getOutputs();

    protected abstract ItemStack[] getSlots();

    protected abstract void setSlots(ItemStack[] var1);

    public boolean hasOutputSlot(ItemStack output) {
        return this.getOutputSlot(output) != -1;
    }

    public int getOutputSlot(ItemStack output) {
        ItemStack[] slots = this.getSlots();
        int[] outputs = this.getOutputs();
        for (int i = 0; i < outputs.length; ++i) {
            int slot = outputs[i];
            if (slots[slot] != null && (!ItemStack.func_77970_a((ItemStack)slots[slot], (ItemStack)output) || slots[slot].func_77973_b() != output.func_77973_b())) continue;
            return slot;
        }
        return -1;
    }

    public int func_174887_a_(int id) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            return this.processTime[id];
        }
        if (id < processCount * 2) {
            return this.totalProcessTime[id - processCount];
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        int processCount = this.getProcessCount();
        if (id < processCount) {
            this.processTime[id] = value;
        } else if (id < processCount * 2) {
            this.totalProcessTime[id - processCount] = value;
        }
    }

    public int func_174890_g() {
        return this.getProcessCount() * 2;
    }

    public void func_174888_l() {
        ItemStack[] slots = this.getSlots();
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = null;
        }
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    protected void mergeStack(int slot, ItemStack stack) {
        ItemStack[] slots = this.getSlots();
        if (slots[slot] == null) {
            slots[slot] = stack;
        } else if (slots[slot].func_77973_b() == stack.func_77973_b() && ItemStack.func_77970_a((ItemStack)slots[slot], (ItemStack)stack)) {
            slots[slot].field_77994_a += stack.field_77994_a;
        }
    }

    protected void decreaseStackSize(int slot) {
        ItemStack[] slots = this.getSlots();
        --slots[slot].field_77994_a;
        if (slots[slot].field_77994_a <= 0) {
            slots[slot] = null;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

