/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.vehicles.helicopter.modules;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterDoor;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterMinigun;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModuleSpot;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterSeat;

public abstract class HelicopterModule {
    public static final Map<String, HelicopterModule> registry = Maps.newHashMap();
    public static final HelicopterModule door = new HelicopterDoor();
    public static final HelicopterModule minigun = new HelicopterMinigun();
    public static final HelicopterSeat seat = new HelicopterSeat();
    private final String moduleID;
    private final Collection<Class<? extends HelicopterModule>> supported;

    protected HelicopterModule(String id) {
        this.moduleID = id;
        registry.put(id, this);
        this.supported = this.createSupportedModuleList();
    }

    protected abstract Collection<Class<? extends HelicopterModule>> createSupportedModuleList();

    public Collection<Class<? extends HelicopterModule>> getSupportedModules() {
        return this.supported;
    }

    public abstract float getBaseRotationAngle();

    public String getModuleID() {
        return this.moduleID;
    }

    public abstract boolean onClicked(HelicopterModuleSpot var1, EntityPlayer var2, Vec3 var3);

    public void onAdded(HelicopterModuleSpot m, EntityPlayer player, Vec3 vec) {
    }

    public void onRemoved(HelicopterModuleSpot m, EntityPlayer player, Vec3 vec) {
    }
}

