/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.vehicles.helicopter.modules;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.message.MessageHelicopterModules;
import org.jurassicraft.common.vehicles.helicopter.EntityHelicopterBase;
import org.jurassicraft.common.vehicles.helicopter.modules.EnumModulePosition;
import org.jurassicraft.common.vehicles.helicopter.modules.HelicopterModule;

public class HelicopterModuleSpot {
    private final List<HelicopterModule> modules;
    private final Map<HelicopterModule, NBTTagCompound> moduleData;
    private final float angleFromCenter;
    private final EnumModulePosition position;
    private final EntityHelicopterBase helicopter;

    public HelicopterModuleSpot(EnumModulePosition pos, EntityHelicopterBase helicopter, float angleFromCenter) {
        this.helicopter = helicopter;
        this.position = pos;
        this.angleFromCenter = angleFromCenter;
        this.modules = Lists.newArrayList();
        this.moduleData = Maps.newHashMap();
    }

    public List<HelicopterModule> getModules() {
        return this.modules;
    }

    public boolean addModule(HelicopterModule m) {
        return this.addModule(m, null, new Vec3(0.0, 0.0, 0.0));
    }

    public boolean addModule(HelicopterModule m, EntityPlayer player, Vec3 v) {
        if (!this.modules.contains(m)) {
            this.modules.add(m);
            if (!this.moduleData.containsKey(m)) {
                this.moduleData.put(m, new NBTTagCompound());
            }
            m.onAdded(this, player, v);
            if (this.getHelicopter().shouldSyncModules() && !this.getHelicopter().field_70170_p.field_72995_K) {
                JurassiCraft.networkManager.networkWrapper.sendToAll((IMessage)new MessageHelicopterModules(this.helicopter.func_145782_y(), this.position, this));
            }
            return true;
        }
        return false;
    }

    public float getAngleFromCenter() {
        return this.angleFromCenter;
    }

    public void readFromNBT(NBTTagCompound tagList) {
        this.modules.clear();
        for (HelicopterModule m : HelicopterModule.registry.values()) {
            if (!tagList.func_74764_b(m.getModuleID())) continue;
            NBTTagCompound data = tagList.func_74775_l(m.getModuleID());
            this.moduleData.put(m, data);
            this.addModule(m);
        }
    }

    public void writeToNBT(NBTTagCompound tagList) {
        for (HelicopterModule m : this.modules) {
            tagList.func_74782_a(m.getModuleID(), (NBTBase)this.moduleData.get(m));
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.modules.clear();
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            String id = ByteBufUtils.readUTF8String((ByteBuf)data);
            HelicopterModule module = HelicopterModule.registry.get(id);
            NBTTagCompound nbt = ByteBufUtils.readTag((ByteBuf)data);
            if (module == null) {
                System.err.println("Null module for id " + id);
                continue;
            }
            System.out.println(">> Read for " + id + " " + nbt);
            this.moduleData.put(module, nbt);
            this.addModule(module);
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.modules.size());
        for (HelicopterModule m : this.modules) {
            ByteBufUtils.writeUTF8String((ByteBuf)data, (String)m.getModuleID());
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)this.getModuleData(m));
            System.out.println("Wrote for " + m.getModuleID() + ": " + this.moduleData.get(m));
        }
    }

    public EnumModulePosition getPosition() {
        return this.position;
    }

    public boolean isClicked(Vec3 v) {
        return this.position.isClicked(v);
    }

    public void onClicked(EntityPlayer player, Vec3 vec) {
        for (HelicopterModule m : this.modules) {
            System.out.println(">> Clicked on " + m.getModuleID());
            if (!m.onClicked(this, player, vec)) continue;
            return;
        }
    }

    public EntityHelicopterBase getHelicopter() {
        return this.helicopter;
    }

    NBTTagCompound getModuleData(HelicopterModule m) {
        return this.moduleData.get(m);
    }

    public boolean has(HelicopterModule module) {
        return this.modules.contains(module);
    }
}

