/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.world;

import java.util.List;
import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;
import org.jurassicraft.JurassiCraft;
import org.jurassicraft.common.block.JCBlockRegistry;
import org.jurassicraft.common.dinosaur.Dinosaur;
import org.jurassicraft.common.entity.base.JCEntityRegistry;
import org.jurassicraft.common.period.EnumTimePeriod;

public class WorldGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_177502_q() == 0) {
            this.generateOverworld(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public void generateOverworld(World world, Random random, int chunkX, int chunkZ) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        for (i = 0; i < 32; ++i) {
            randPosX = chunkX + random.nextInt(16);
            randPosY = random.nextInt(64);
            randPosZ = chunkZ + random.nextInt(16);
            EnumTimePeriod period = null;
            for (EnumTimePeriod p : EnumTimePeriod.values()) {
                if (randPosY >= EnumTimePeriod.getEndYLevel(p) || randPosY <= EnumTimePeriod.getStartYLevel(p)) continue;
                period = p;
                break;
            }
            if (period == null) continue;
            randPosY += random.nextInt(4) - 2;
            List<Dinosaur> dinos = JCEntityRegistry.getDinosaursFromPeriod(period);
            if (dinos == null || dinos.size() <= 0) continue;
            Dinosaur dinosaur = dinos.get(random.nextInt(dinos.size()));
            int meta = JurassiCraft.blockRegistry.getMetadata(dinosaur);
            new WorldGenMinable(JurassiCraft.blockRegistry.getFossilBlock(dinosaur).func_176203_a(meta), 5).func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
        }
        for (i = 0; i < 16; ++i) {
            randPosX = chunkX + random.nextInt(16);
            randPosY = random.nextInt(20);
            randPosZ = chunkZ + random.nextInt(16);
            new WorldGenMinable(JCBlockRegistry.amber_ore.func_176223_P(), 3).func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
        }
        for (i = 0; i < 32; ++i) {
            randPosX = chunkX + random.nextInt(16);
            randPosY = random.nextInt(64);
            randPosZ = chunkZ + random.nextInt(16);
            new WorldGenMinable(JCBlockRegistry.ice_shard.func_176223_P(), 1).func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
        }
        for (i = 0; i < 2; ++i) {
            randPosX = chunkX + random.nextInt(16);
            randPosY = random.nextInt(128);
            randPosZ = chunkZ + random.nextInt(16);
            new WorldGenMinable(JCBlockRegistry.gypsum_stone.func_176223_P(), 10).func_180709_b(world, random, new BlockPos(randPosX, randPosY, randPosZ));
        }
    }
}

