/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.world.jurdstrees.algorythms;

import java.util.ArrayList;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeBlock;

public class Shape {
    private int shapeCode;
    public ArrayList<TreeBlock> blocksList = new ArrayList();

    public Shape(int code) {
        this.shapeCode = code;
        this.addLog(0, 0, 0);
    }

    public boolean addLog(int x, int y, int z, int level) {
        TreeBlock currentBlock = new TreeBlock(x, y, z, level);
        for (TreeBlock TB : this.blocksList) {
            if (!TB.equals(currentBlock)) continue;
            return false;
        }
        this.blocksList.add(new TreeBlock(x, y, z, level));
        return true;
    }

    public boolean addLog(int x, int y, int z) {
        TreeBlock currentBlock = new TreeBlock(x, y, z, 0);
        for (TreeBlock TB : this.blocksList) {
            if (!TB.equals(currentBlock)) continue;
            return false;
        }
        this.blocksList.add(new TreeBlock(x, y, z, 0));
        return true;
    }

    public boolean addInsPoint(int x, int y, int z, int level) {
        TreeBlock currentBlock = new TreeBlock(x, y, z, level);
        for (TreeBlock TB : this.blocksList) {
            if (!TB.equals(currentBlock)) continue;
            return false;
        }
        TreeBlock treeBlock = currentBlock;
        treeBlock.getClass();
        this.blocksList.add(new TreeBlock.InsPoint(treeBlock, x, y, z, level, TreeBlock.Rotation.none));
        return true;
    }

    public boolean addInsPointWithRotation(int x, int y, int z, int level, TreeBlock.Rotation rotation) {
        TreeBlock currentBlock = new TreeBlock(x, y, z, level);
        for (TreeBlock TB : this.blocksList) {
            if (!TB.equals(currentBlock)) continue;
            return false;
        }
        TreeBlock treeBlock = currentBlock;
        treeBlock.getClass();
        this.blocksList.add(new TreeBlock.InsPoint(treeBlock, x, y, z, level, rotation));
        return true;
    }

    public boolean addInsPointWithTrunk(int x, int y, int z, int level, TreeBlock.Rotation rotation) {
        TreeBlock currentBlock = new TreeBlock(x, y, z, level);
        for (TreeBlock TB : this.blocksList) {
            if (!TB.equals(currentBlock)) continue;
            return false;
        }
        TreeBlock treeBlock = currentBlock;
        treeBlock.getClass();
        this.blocksList.add(new TreeBlock.InsPoint(treeBlock, x, y, z, level, rotation, true, false));
        return true;
    }

    public boolean addInsPointWithLeaves(int x, int y, int z, TreeBlock.Rotation rotation) {
        return this.addInsPointAskTrunkAndLeaves(x, y, z, 0, rotation, false, true);
    }

    public boolean addInsPointAskTrunkAndLeaves(int x, int y, int z, int level, TreeBlock.Rotation rotation, boolean trunk, boolean leaves) {
        TreeBlock currentBlock = new TreeBlock(x, y, z, level);
        for (TreeBlock TB : this.blocksList) {
            if (!TB.equals(currentBlock)) continue;
            return false;
        }
        TreeBlock treeBlock = currentBlock;
        treeBlock.getClass();
        this.blocksList.add(new TreeBlock.InsPoint(treeBlock, x, y, z, level, rotation, trunk, leaves));
        return true;
    }

    public int getCode() {
        return this.shapeCode;
    }
}

