/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.world.jurdstrees.algorythms;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import org.jurassicraft.common.block.JCBlockRegistry;
import org.jurassicraft.common.world.jurdstrees.algorythms.Feature;
import org.jurassicraft.common.world.jurdstrees.algorythms.InsPCoord;
import org.jurassicraft.common.world.jurdstrees.algorythms.Shape;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeBlock;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeCompendium;

public class Tree {
    private int treeCode;
    private int[] TrunkList;
    private int[] BranchList;
    private int[] WoodList;
    private int[] LeafList;
    private int[] TrunkLeafList;
    private int[] FruitList;
    private int penaltyPerHeight;
    private int lowerBranchLevel;
    private int age;
    private int maxAge;
    private int maxBranchLevel;
    private int maxTrunkHeight;
    private ArrayList<InsPCoord> insPList = new ArrayList();

    public Tree(int code, int maxAge, int maxBranchLength) {
        this.treeCode = code;
        this.maxAge = maxAge;
        this.maxBranchLevel = maxBranchLength;
        this.penaltyPerHeight = 3;
        this.lowerBranchLevel = 0;
        this.maxTrunkHeight = 30;
    }

    public static Block getBlocksFromCode(int code) {
        return JCBlockRegistry.woods[code];
    }

    public static Block getLeavesFromCode(int code) {
        return JCBlockRegistry.leaves[code];
    }

    public Tree(int code, int maxAge, int maxBranchLength, int penalty, int lbl, int mtheight) {
        this.treeCode = code;
        this.maxAge = maxAge;
        this.maxBranchLevel = maxBranchLength;
        this.penaltyPerHeight = penalty;
        this.lowerBranchLevel = lbl;
        this.maxTrunkHeight = mtheight;
    }

    public int getCode() {
        return this.treeCode;
    }

    public Tree getBaseCopy() {
        Tree tree = new Tree(this.treeCode, this.maxAge, this.maxBranchLevel, this.penaltyPerHeight, this.lowerBranchLevel, this.maxTrunkHeight);
        tree.addFeatureList(this.TrunkList, Feature.FeatureType.Trunk);
        tree.addFeatureList(this.BranchList, Feature.FeatureType.Branch);
        tree.addFeatureList(this.FruitList, Feature.FeatureType.Fruit);
        tree.addFeatureList(this.LeafList, Feature.FeatureType.leaves);
        tree.addFeatureList(this.WoodList, Feature.FeatureType.wood);
        tree.addFeatureList(this.TrunkLeafList, Feature.FeatureType.TrunkLeaves);
        return tree;
    }

    public boolean hasBeenGenerated() {
        return this.insPList.size() != 0;
    }

    public void addFeatureList(int[] featureList, Feature.FeatureType type) {
        switch (type) {
            case Branch: {
                this.BranchList = featureList;
                break;
            }
            case Fruit: {
                this.FruitList = featureList;
                break;
            }
            case Trunk: {
                this.TrunkList = featureList;
                break;
            }
            case leaves: {
                this.LeafList = featureList;
                break;
            }
            case wood: {
                this.WoodList = featureList;
                break;
            }
            case TrunkLeaves: {
                this.TrunkLeafList = featureList;
                break;
            }
        }
    }

    public boolean generateTree() {
        if (this.TrunkList == null || this.BranchList == null || this.WoodList == null || this.LeafList == null || this.FruitList == null || this.TrunkLeafList == null) {
            return false;
        }
        Random random = new Random();
        this.insPList.add(new InsPCoord(this.TrunkList[random.nextInt(this.TrunkList.length)], InsPCoord.InsPType.getTypeIndex(InsPCoord.InsPType.trunk), 0, 0, 0, 0, 1, 0, 0, 0));
        for (int i = 1; i < this.maxAge; ++i) {
            int size = this.insPList.size();
            for (int j = 0; j < size; ++j) {
                Shape leavesShape;
                Shape shape;
                if (this.insPList.get(j).getBuilt() != 0) continue;
                if (this.insPList.get(j).getTrunk() == 1) {
                    if (this.insPList.get(j).getY() >= this.maxTrunkHeight) continue;
                    shape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.getRotationFromIndex(this.insPList.get(j).getRotation()));
                    this.addNewInsertPoints(random, i, j, shape, InsPCoord.InsPType.trunk, false);
                    continue;
                }
                if (this.insPList.get(j).getLevel() < this.maxBranchLevel) {
                    if (this.insPList.get(j).getRotation() != 0 && this.insPList.get(j).getLeaves() == 0) {
                        shape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.getRotationFromIndex(this.insPList.get(j).getRotation()));
                        this.addNewInsertPoints(random, i, j, shape, InsPCoord.InsPType.branch, false);
                    }
                    if (this.insPList.get(j).getRotation() == 0) {
                        shape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.east);
                        this.addNewInsertPoints(random, i, j, shape, InsPCoord.InsPType.branch, false);
                        shape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.north);
                        this.addNewInsertPoints(random, i, j, shape, InsPCoord.InsPType.branch, false);
                        shape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.west);
                        this.addNewInsertPoints(random, i, j, shape, InsPCoord.InsPType.branch, false);
                        shape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.south);
                        this.addNewInsertPoints(random, i, j, shape, InsPCoord.InsPType.branch, false);
                    }
                }
                if (this.insPList.get(j).getLevel() < this.maxBranchLevel) continue;
                if (this.insPList.get(j).getRotation() != 0) {
                    leavesShape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.getRotationFromIndex(this.insPList.get(j).getRotation()));
                    this.addNewInsertPoints(random, i, j, leavesShape, InsPCoord.InsPType.branch, true);
                    continue;
                }
                leavesShape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.east);
                this.addNewInsertPoints(random, i, j, leavesShape, InsPCoord.InsPType.branch, true);
                leavesShape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.north);
                this.addNewInsertPoints(random, i, j, leavesShape, InsPCoord.InsPType.branch, true);
                leavesShape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.west);
                this.addNewInsertPoints(random, i, j, leavesShape, InsPCoord.InsPType.branch, true);
                leavesShape = TreeCompendium.getRotatedShapeFromCode(this.insPList.get(j).getCode(), TreeBlock.Rotation.south);
                this.addNewInsertPoints(random, i, j, leavesShape, InsPCoord.InsPType.branch, true);
            }
        }
        return true;
    }

    private void addNewInsertPoints(Random random, int i, int j, Shape shape, InsPCoord.InsPType type, boolean addLeavesInsPOnly) {
        for (TreeBlock block : shape.blocksList) {
            if (!(block instanceof TreeBlock.InsPoint)) continue;
            TreeBlock.InsPoint insertp = (TreeBlock.InsPoint)block;
            int xC = this.insPList.get(j).getX() + insertp.getX();
            int yC = this.insPList.get(j).getY() + insertp.getY();
            int zC = this.insPList.get(j).getZ() + insertp.getZ();
            if (insertp.allowTrunk && !addLeavesInsPOnly) {
                int newRotation = 0;
                newRotation = insertp.rotation == TreeBlock.Rotation.none ? random.nextInt(4) + 1 : TreeBlock.Rotation.getRotationIndex(insertp.rotation);
                this.insPList.get(j).turnBuilt();
                this.insPList.add(new InsPCoord(this.TrunkList[new Random().nextInt(this.TrunkList.length)], InsPCoord.InsPType.getTypeIndex(type), xC, yC, zC, i, 1, 0, newRotation, insertp.getLeaves() ? 1 : 0));
                continue;
            }
            if (insertp.growLeaves) {
                this.insPList.add(new InsPCoord(this.LeafList[new Random().nextInt(this.LeafList.length)], InsPCoord.InsPType.getTypeIndex(type), xC, yC, zC, i, 0, 0, TreeBlock.Rotation.getRotationIndex(insertp.rotation), insertp.getLeaves() ? 1 : 0));
            } else if (!addLeavesInsPOnly) {
                if (insertp.rotation == TreeBlock.Rotation.none) {
                    this.insPList.add(new InsPCoord(this.BranchList[new Random().nextInt(this.BranchList.length)], InsPCoord.InsPType.getTypeIndex(type), xC, yC, zC, i, 0, 0, TreeBlock.Rotation.getRotationIndex(insertp.rotation), insertp.getLeaves() ? 1 : 0));
                } else if (this.insPList.get(j).getY() > i * this.lowerBranchLevel) {
                    this.insPList.add(new InsPCoord(shape.getCode(), InsPCoord.InsPType.getTypeIndex(type), xC, yC, zC, i, 0, 0, TreeBlock.Rotation.getRotationIndex(insertp.rotation), insertp.getLeaves() ? 1 : 0));
                }
            }
            this.insPList.get(j).turnBuilt();
        }
    }

    public ArrayList<InsPCoord> getInsPList() {
        return this.insPList;
    }

    public int[] getWoodList() {
        return this.WoodList;
    }

    public int[] getLeavesList() {
        return this.LeafList;
    }

    public int[] getTrunkLeavesList() {
        return this.TrunkLeafList;
    }

    public int getPenalty() {
        return this.penaltyPerHeight;
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void increaseAge() {
        ++this.age;
    }
}

