/*
 * Decompiled with CFR 0.152.
 */
package org.jurassicraft.common.world.jurdstrees.algorythms;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import org.jurassicraft.common.block.JCBlockRegistry;
import org.jurassicraft.common.world.jurdstrees.algorythms.InsPCoord;
import org.jurassicraft.common.world.jurdstrees.algorythms.Shape;
import org.jurassicraft.common.world.jurdstrees.algorythms.Tree;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeBlock;
import org.jurassicraft.common.world.jurdstrees.algorythms.TreeCompendium;

public class TreeGenerator {
    private Tree tree;
    private int code;
    private BlockPos pos;
    private World world;
    int x;
    int y;
    int z;
    private Random random = new Random();

    public TreeGenerator(int code, World world, BlockPos pos) {
        this.world = world;
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.code = code;
        this.pos = pos;
    }

    public void placeTree() {
        if (!this.world.field_72995_K) {
            this.tree = TreeCompendium.getTreeFromCode(this.code);
            if (!this.tree.hasBeenGenerated()) {
                this.tree.generateTree();
            }
            for (InsPCoord coord : this.tree.getInsPList()) {
                if (coord.getLevel() <= this.tree.getMaxAge()) {
                    Shape skull = TreeCompendium.getRotatedShapeFromCode(coord.getCode(), TreeBlock.Rotation.getRotationFromIndex(coord.getRotation()));
                    Shape wood = TreeCompendium.getRotatedShapeFromCode(this.tree.getWoodList()[this.random.nextInt(this.tree.getWoodList().length)], TreeBlock.Rotation.getRotationFromIndex(coord.getRotation()));
                    if (coord.getLeaves() == 0) {
                        this.setBlocksFromShape(this.world, this.x, this.y, this.z, coord, skull, wood);
                        if (coord.getTrunk() == 0 && coord.getRotation() == 0) {
                            skull = TreeCompendium.getRotatedShapeFromCode(coord.getCode(), TreeBlock.Rotation.north);
                            this.setBlocksFromShape(this.world, this.x, this.y, this.z, coord, skull, wood);
                            skull = TreeCompendium.getRotatedShapeFromCode(coord.getCode(), TreeBlock.Rotation.west);
                            this.setBlocksFromShape(this.world, this.x, this.y, this.z, coord, skull, wood);
                            skull = TreeCompendium.getRotatedShapeFromCode(coord.getCode(), TreeBlock.Rotation.south);
                            this.setBlocksFromShape(this.world, this.x, this.y, this.z, coord, skull, wood);
                        }
                    }
                }
                this.buildLeavesFromInsPCoord(this.world, this.x, this.y, this.z, coord);
            }
        }
    }

    private void buildLeavesFromInsPCoord(World world, int x, int y, int z, InsPCoord coord) {
        IBlockState leaves = Tree.getLeavesFromCode(this.tree.getCode()).func_176223_P();
        if (coord.getLevel() <= this.tree.getMaxAge() + 1 && coord.getLeaves() == 1) {
            int leafCode = coord.getType() == InsPCoord.InsPType.getTypeIndex(InsPCoord.InsPType.trunk) ? this.tree.getTrunkLeavesList()[this.random.nextInt(this.tree.getTrunkLeavesList().length)] : this.tree.getLeavesList()[this.random.nextInt(this.tree.getLeavesList().length)];
            Shape leaf = TreeCompendium.getRotatedShapeFromCode(leafCode, TreeBlock.Rotation.getRotationFromIndex(coord.getRotation()));
            for (TreeBlock LeafB : leaf.blocksList) {
                int zW;
                int yW;
                int xW;
                if (coord.getType() == InsPCoord.InsPType.getTypeIndex(InsPCoord.InsPType.trunk)) {
                    xW = x + -LeafB.getY() + coord.getX();
                    yW = y + LeafB.getX() + coord.getY();
                    zW = z + LeafB.getZ() + coord.getZ();
                } else {
                    xW = x + LeafB.getX() + coord.getX();
                    yW = y + LeafB.getY() + coord.getY();
                    zW = z + LeafB.getZ() + coord.getZ();
                }
                if (world.func_180495_p(this.pos.func_177982_a(xW, yW, zW)) != Blocks.field_150350_a.func_176223_P() && world.func_180495_p(new BlockPos(xW, yW, zW)).func_177230_c() != Tree.getLeavesFromCode(this.tree.getCode())) continue;
                world.func_175656_a(this.pos.func_177982_a(xW, yW, zW), leaves);
            }
        }
    }

    private void setBlocksFromShape(World world, int x, int y, int z, InsPCoord coord, Shape skull, Shape wood) {
        IBlockState logs = Tree.getBlocksFromCode(this.tree.getCode()).func_176223_P();
        for (TreeBlock TB : skull.blocksList) {
            int zC;
            int yC;
            int xC = x + TB.getX() + coord.getX();
            if (world.func_180495_p(this.pos.func_177982_a(xC, yC = y + TB.getY() + coord.getY(), zC = z + TB.getZ() + coord.getZ())) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)) == Tree.getBlocksFromCode(this.tree.getCode()).func_176223_P() || world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)) == Tree.getLeavesFromCode(this.tree.getCode()).func_176223_P() || world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)).func_177230_c() == JCBlockRegistry.saplings[this.tree.getCode()]) {
                if (world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)) == Blocks.field_150350_a.func_176223_P() || world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)) == Tree.getLeavesFromCode(this.tree.getCode()).func_176223_P() || world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)).func_177230_c() == JCBlockRegistry.saplings[this.tree.getCode()]) {
                    world.func_175656_a(this.pos.func_177982_a(xC, yC, zC), logs);
                }
                for (TreeBlock WoodB : wood.blocksList) {
                    int xW = x + TB.getX() + WoodB.getX() + coord.getX();
                    int yW = y + TB.getY() + WoodB.getY() + coord.getY();
                    int zW = z + TB.getZ() + WoodB.getZ() + coord.getZ();
                    int ageLevel = this.tree.getMaxAge() - (yW - y) / this.tree.getPenalty();
                    if (WoodB.level >= ageLevel || world.func_180495_p(this.pos.func_177982_a(xW, yW, zW)) != Blocks.field_150350_a.func_176223_P() && world.func_180495_p(this.pos.func_177982_a(xW, yW, zW)) != Tree.getLeavesFromCode(this.tree.getCode()).func_176223_P()) continue;
                    world.func_175656_a(this.pos.func_177982_a(xW, yW, zW), logs);
                }
                continue;
            }
            if (world.func_180495_p(this.pos.func_177982_a(xC, yC, zC)) == Tree.getBlocksFromCode(this.tree.getCode()).func_176223_P()) continue;
            break;
        }
    }
}

