/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.config;

import java.util.HashMap;
import java.util.Map;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.gui.config.ConfigCategory;
import net.ilexiconn.llibrary.client.gui.config.ConfigGUI;
import net.ilexiconn.llibrary.client.gui.config.ConfigProperty;
import net.ilexiconn.llibrary.server.util.IValueAccess;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LLibraryConfigGUI
extends ConfigGUI {
    private static final Map<String, ConfigProperty<?>> GENERAL_PROPERTIES = new HashMap();
    private static final Map<String, ConfigProperty<?>> APPEARANCE_PROPERTIES = new HashMap();

    public LLibraryConfigGUI(GuiScreen parent) {
        super(parent, LLibrary.INSTANCE, null);
        this.categories.add(new ConfigCategory("General", GENERAL_PROPERTIES));
        this.categories.add(new ConfigCategory("Appearance", APPEARANCE_PROPERTIES));
    }

    @Override
    public void func_146281_b() {
        LLibrary.CONFIG.save();
        super.func_146281_b();
    }

    static {
        GENERAL_PROPERTIES.put("Patreon Effects", new ConfigProperty<Boolean>(new IValueAccess<Boolean>(){

            @Override
            public Boolean get() {
                return LLibrary.CONFIG.hasPatreonEffects();
            }

            @Override
            public void accept(Boolean patreonEffects) {
                LLibrary.CONFIG.setPatreonEffects(patreonEffects);
            }
        }, Property.Type.BOOLEAN));
        GENERAL_PROPERTIES.put("Version Checker", new ConfigProperty<Boolean>(new IValueAccess<Boolean>(){

            @Override
            public Boolean get() {
                return LLibrary.CONFIG.hasVersionCheck();
            }

            @Override
            public void accept(Boolean versionCheck) {
                LLibrary.CONFIG.setVersionCheck(versionCheck);
            }
        }, Property.Type.BOOLEAN));
        GENERAL_PROPERTIES.put("Survival Tabs Always Visible", new ConfigProperty<Boolean>(new IValueAccess<Boolean>(){

            @Override
            public Boolean get() {
                return LLibrary.CONFIG.areTabsAlwaysVisible();
            }

            @Override
            public void accept(Boolean tabsAlwaysVisible) {
                LLibrary.CONFIG.setTabsAlwaysVisible(tabsAlwaysVisible);
            }
        }, Property.Type.BOOLEAN));
        GENERAL_PROPERTIES.put("Survival Tabs Left Side", new ConfigProperty<Boolean>(new IValueAccess<Boolean>(){

            @Override
            public void accept(Boolean tabsLeftSide) {
                LLibrary.CONFIG.setTabsLeftSide(tabsLeftSide);
            }

            @Override
            public Boolean get() {
                return LLibrary.CONFIG.areTabsLeftSide();
            }
        }, Property.Type.BOOLEAN));
        APPEARANCE_PROPERTIES.put("Accent Color", new ConfigProperty<Integer>(new IValueAccess<Integer>(){

            @Override
            public Integer get() {
                return LLibrary.CONFIG.getAccentColor();
            }

            @Override
            public void accept(Integer accentColor) {
                LLibrary.CONFIG.setAccentColor(accentColor);
            }
        }, Property.Type.COLOR));
        APPEARANCE_PROPERTIES.put("Dark Mode", new ConfigProperty<Boolean>(new IValueAccess<Boolean>(){

            @Override
            public Boolean get() {
                return LLibrary.CONFIG.getColorMode().equals("dark");
            }

            @Override
            public void accept(Boolean colorMode) {
                LLibrary.CONFIG.setColorMode(colorMode != false ? "dark" : "light");
            }
        }, Property.Type.BOOLEAN));
    }
}

