/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public enum ElementHandler {
    INSTANCE;

    private Map<GuiScreen, List<Element<?>>> elementMap = new HashMap();
    private Element<?> currentlyClicking;

    public <T extends GuiScreen> void addElement(T gui, Element<T> element) {
        if (this.elementMap.containsKey(gui)) {
            this.elementMap.get(gui).add(element);
        } else {
            ArrayList<Element<T>> elementList = new ArrayList<Element<T>>();
            elementList.add(element);
            this.elementMap.put(gui, elementList);
        }
    }

    public <T extends GuiScreen> void removeElement(T gui, Element<T> element) {
        if (this.elementMap.containsKey(gui)) {
            this.elementMap.get(gui).remove(element);
        }
    }

    public <T extends GuiScreen> void clearElements(T gui) {
        if (this.elementMap.containsKey(gui)) {
            this.elementMap.remove(gui);
        }
    }

    public <T extends GuiScreen> boolean isElementOnTop(T gui, Element<T> element) {
        if (this.elementMap.containsKey(gui)) {
            List elementList = Lists.reverse(new ArrayList(this.elementMap.get(gui)));
            this.addChildren(elementList);
            float mouseX = this.getPreciseMouseX(gui);
            float mouseY = this.getPreciseMouseY(gui);
            for (Element e : elementList) {
                if (!e.isVisible() || !(mouseX >= e.getPosX()) || !(mouseY >= e.getPosY()) || !(mouseX < e.getPosX() + (float)e.getWidth()) || !(mouseY < e.getPosY() + (float)e.getHeight())) continue;
                return element == e || element.getParent() != null && element.getParent() == e;
            }
            return false;
        }
        return true;
    }

    public <T extends GuiScreen> void onInit(T gui) {
        if (this.elementMap.containsKey(gui)) {
            ArrayList<Element<T>> elementList = new ArrayList<Element<T>>(this.elementMap.get(gui));
            this.addChildren(elementList);
            new ArrayList<Element<T>>(elementList).stream().forEach(Element::init);
        }
    }

    public <T extends GuiScreen> void onUpdate(T gui) {
        if (this.elementMap.containsKey(gui)) {
            ArrayList<Element<T>> elementList = new ArrayList<Element<T>>(this.elementMap.get(gui));
            this.addChildren(elementList);
            elementList.stream().forEach(Element::update);
        }
    }

    public <T extends GuiScreen> void onRender(T gui, float partialTicks) {
        if (this.elementMap.containsKey(gui)) {
            ArrayList elementList = new ArrayList(this.elementMap.get(gui));
            float mouseX = this.getPreciseMouseX(gui);
            float mouseY = this.getPreciseMouseY(gui);
            elementList.stream().forEach(element -> this.onRenderElement((Element)element, mouseX, mouseY, partialTicks));
        }
    }

    private <T extends GuiScreen> void onRenderElement(Element<T> element, float mouseX, float mouseY, float partialTicks) {
        if (element.isVisible()) {
            element.render(mouseX, mouseY, partialTicks);
            for (Element<T> child : element.getChildren()) {
                this.onRenderElement(child, mouseX, mouseY, partialTicks);
            }
        }
    }

    public <T extends GuiScreen> void onMouseClicked(T gui, int button) {
        if (this.elementMap.containsKey(gui)) {
            ArrayList<Element<T>> elementList = new ArrayList<Element<T>>(this.elementMap.get(gui));
            this.addChildren(elementList);
            float mouseX = this.getPreciseMouseX(gui);
            float mouseY = this.getPreciseMouseY(gui);
            for (Element element : Lists.reverse(elementList)) {
                if (!element.isVisible() || !element.isEnabled() || !element.mouseClicked(mouseX, mouseY, button)) continue;
                this.currentlyClicking = element;
                return;
            }
        }
    }

    public <T extends GuiScreen> void onMouseDragged(T gui, int button, long timeSinceClick) {
        if (this.elementMap.containsKey(gui)) {
            ArrayList<Element<T>> elementList = new ArrayList<Element<T>>(this.elementMap.get(gui));
            this.addChildren(elementList);
            float mouseX = this.getPreciseMouseX(gui);
            float mouseY = this.getPreciseMouseY(gui);
            for (Element element : Lists.reverse(elementList)) {
                if (!element.isVisible() || !element.isEnabled() || this.currentlyClicking != element || !element.mouseDragged(mouseX, mouseY, button, timeSinceClick)) continue;
                return;
            }
        }
    }

    public <T extends GuiScreen> void onMouseReleased(T gui, int button) {
        if (this.elementMap.containsKey(gui)) {
            ArrayList<Element<T>> elementList = new ArrayList<Element<T>>(this.elementMap.get(gui));
            this.addChildren(elementList);
            float mouseX = this.getPreciseMouseX(gui);
            float mouseY = this.getPreciseMouseY(gui);
            for (Element element : Lists.reverse(elementList)) {
                if (!element.isVisible() || !element.isEnabled() || this.currentlyClicking != element || !element.mouseReleased(mouseX, mouseY, button)) continue;
                return;
            }
        }
    }

    public <T extends GuiScreen> void onKeyPressed(T gui, char character, int key) {
        if (this.elementMap.containsKey(gui)) {
            List elementList = Lists.reverse(new ArrayList(new ArrayList(this.elementMap.get(gui))));
            this.addChildren(elementList);
            for (Element element : elementList) {
                if (!element.isVisible() || !element.isEnabled() || !element.keyPressed(character, key)) continue;
                return;
            }
        }
    }

    public <T extends GuiScreen> void onMouseScrolled(T gui, int amount) {
        if (this.elementMap.containsKey(gui)) {
            List elementList = Lists.reverse(new ArrayList(new ArrayList(this.elementMap.get(gui))));
            this.addChildren(elementList);
            float mouseX = this.getPreciseMouseX(gui);
            float mouseY = this.getPreciseMouseY(gui);
            for (Element element : elementList) {
                if (!element.isVisible() || !element.isEnabled() || !element.mouseScrolled(mouseX, mouseY, amount)) continue;
                return;
            }
        }
    }

    public <T extends GuiScreen> float getPreciseMouseX(T gui) {
        ScaledResolution scaledResolution = new ScaledResolution(ClientProxy.MINECRAFT);
        return (float)Mouse.getX() / (float)scaledResolution.func_78325_e();
    }

    public <T extends GuiScreen> float getPreciseMouseY(T gui) {
        return (float)gui.field_146295_m - (float)Mouse.getY() * (float)gui.field_146295_m / (float)gui.field_146297_k.field_71440_d - 1.0f;
    }

    private <T extends GuiScreen> void addChildren(List<Element<T>> elements) {
        for (Element<T> element : new ArrayList<Element<T>>(elements)) {
            ArrayList<Element<T>> children = new ArrayList<Element<T>>();
            int index = elements.indexOf(element);
            for (Element<Object> child : element.getChildren()) {
                ArrayList<Element<T>> newChildren = new ArrayList<Element<T>>();
                newChildren.add(child);
                this.addChildren(newChildren);
                children.addAll(newChildren);
            }
            for (Element<Object> child : children) {
                elements.add(index, child);
            }
        }
    }
}

