/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import java.util.List;
import java.util.function.Function;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.ilexiconn.llibrary.client.gui.element.ElementHandler;
import net.ilexiconn.llibrary.client.gui.element.ScrollbarElement;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ListElement<T extends GuiScreen>
extends Element<T> {
    private List<String> entries;
    private Function<ListElement<T>, Boolean> function;
    private ScrollbarElement<T> scrollbar;
    private int entryHeight;
    private int selectedEntry = -1;

    public ListElement(T gui, float posX, float posY, int width, int height, List<String> entries, Function<ListElement<T>, Boolean> function) {
        this(gui, posX, posY, width, height, entries, 13, function);
    }

    public ListElement(T gui, float posX, float posY, int width, int height, List<String> entries, int entryHeight, Function<ListElement<T>, Boolean> function) {
        super(gui, posX, posY, width, height);
        this.entries = entries;
        this.function = function;
        this.entryHeight = entryHeight;
    }

    @Override
    public void init() {
        this.scrollbar = new ScrollbarElement(this, () -> Float.valueOf((float)this.getWidth() - 8.0f), () -> Float.valueOf(2.0f), () -> Float.valueOf((float)this.getHeight() - 3.0f), this.entryHeight, () -> this.entries.size());
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        this.drawRectangle(this.getPosX(), this.getPosY(), this.getWidth(), this.getHeight(), this.getColorScheme().getSecondaryColor());
        FontRenderer fontRenderer = ((GuiScreen)this.getGUI()).field_146297_k.field_71466_p;
        float y = -this.scrollbar.getScrollOffset();
        GL11.glEnable((int)3089);
        ScaledResolution scaledResolution = new ScaledResolution(ClientProxy.MINECRAFT);
        int scaleFactor = scaledResolution.func_78325_e();
        GL11.glScissor((int)((int)(this.getPosX() * (float)scaleFactor)), (int)((int)(((float)((GuiScreen)this.getGUI()).field_146295_m - (this.getPosY() + (float)this.getHeight()) + 2.0f) * (float)scaleFactor)), (int)(this.getWidth() * scaleFactor), (int)((this.getHeight() - 4) * scaleFactor));
        int entryIndex = 0;
        for (String entry : this.entries) {
            boolean clickSelecting;
            float entryX = this.getPosX() + 2.0f;
            float entryY = this.getPosY() + y + 1.0f;
            float entryWidth = this.getWidth() - 6;
            boolean selected = this.isSelected(this.getPosX(), this.getPosY() + y, entryWidth, this.entryHeight, mouseX, mouseY) && !this.scrollbar.isScrolling();
            boolean bl = clickSelecting = selected && Mouse.isButtonDown((int)0);
            if (this.selectedEntry == entryIndex) {
                this.drawRectangle(entryX, entryY, entryWidth, this.entryHeight, clickSelecting ? LLibrary.CONFIG.getAccentColor() : LLibrary.CONFIG.getDarkAccentColor());
            } else {
                this.drawRectangle(entryX, entryY, entryWidth, this.entryHeight, selected ? LLibrary.CONFIG.getAccentColor() : this.getColorScheme().getSecondaryColor());
            }
            fontRenderer.func_175065_a(entry, entryX + 2.0f, entryY - (float)(fontRenderer.field_78288_b / 2) + (float)(this.entryHeight / 2), LLibrary.CONFIG.getTextColor(), false);
            y += (float)this.entryHeight;
            ++entryIndex;
        }
        GL11.glDisable((int)3089);
        this.drawRectangle(this.getPosX() + (float)this.getWidth() - 9.0f, this.getPosY() + 1.0f, 6.0, this.getHeight() - 2, this.getColorScheme().getPrimaryColor());
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        if (this.isSelected(mouseX, mouseY)) {
            float y = -this.scrollbar.getScrollOffset();
            for (int entryIndex = 0; entryIndex < this.entries.size(); ++entryIndex) {
                float entryWidth;
                float entryY;
                float entryX = this.getPosX() + 2.0f;
                if (this.isSelected(entryX, entryY = this.getPosY() + y + 1.0f, entryWidth = (float)(this.getWidth() - this.entryHeight), this.entryHeight, mouseX, mouseY)) {
                    int previousSelected = this.selectedEntry;
                    this.selectedEntry = entryIndex;
                    if (this.function.apply(this).booleanValue()) {
                        ((GuiScreen)this.getGUI()).field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                    } else {
                        this.selectedEntry = previousSelected;
                    }
                    return true;
                }
                y += (float)this.entryHeight;
            }
        }
        return false;
    }

    private boolean isSelected(float entryX, float entryY, float entryWidth, float entryHeight, float mouseX, float mouseY) {
        return ElementHandler.INSTANCE.isElementOnTop(this.getGUI(), this) && mouseX > entryX && mouseX < entryX + entryWidth && mouseY > entryY && mouseY < entryY + entryHeight;
    }

    public int getSelectedIndex() {
        return this.selectedEntry;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedEntry = selectedIndex;
    }

    public String getSelectedEntry() {
        return this.entries.get(this.selectedEntry);
    }

    public ListElement<T> withPersistence(boolean persistent) {
        this.selectedEntry = 0;
        return this;
    }
}

