/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.client.render;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderPlayerEvent;

@SideOnly(value=Side.CLIENT)
public class RenderPlayerEventHandler {
    public ResourceLocation capeDeveloper = new ResourceLocation("jurassicraft", "textures/cape/developer_cape.png");
    public ResourceLocation capePatron = new ResourceLocation("jurassicraft", "textures/cape/patron_cape.png");

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Pre event) {
        AbstractClientPlayer player = (AbstractClientPlayer)event.entityPlayer;
        UUID uniqueID = player.func_110124_au();
        try {
            if (this.isDeveloper(uniqueID)) {
                player.func_152121_a(MinecraftProfileTexture.Type.CAPE, this.capeDeveloper);
            } else if (this.isPatron(uniqueID)) {
                player.func_152121_a(MinecraftProfileTexture.Type.CAPE, this.capePatron);
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load capes!");
            e.printStackTrace();
        }
    }

    public boolean isDeveloper(UUID uuid) throws Exception {
        return JurassiCraft.capeContainer.getDevelopers().contains(uuid.toString());
    }

    public boolean isPatron(UUID uuid) throws Exception {
        return JurassiCraft.capeContainer.getPatrons().contains(uuid.toString());
    }
}

