/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.tileentity;

import java.util.ArrayList;
import net.ilexiconn.jurassicraft.common.api.IDNASource;
import net.ilexiconn.jurassicraft.common.entity.Creature;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;
import net.ilexiconn.jurassicraft.common.handler.JurassiCraftDNAHandler;
import net.ilexiconn.jurassicraft.common.item.ItemAmber;
import net.ilexiconn.jurassicraft.common.item.ItemBristles;
import net.ilexiconn.jurassicraft.common.item.ItemDNA;
import net.ilexiconn.jurassicraft.common.item.ItemFeather;
import net.ilexiconn.jurassicraft.common.item.ItemFossil;
import net.ilexiconn.jurassicraft.common.item.ItemFur;
import net.ilexiconn.jurassicraft.common.item.ItemMeat;
import net.ilexiconn.jurassicraft.common.item.ItemScale;
import net.ilexiconn.jurassicraft.common.item.ItemSkin;
import net.ilexiconn.jurassicraft.common.item.ItemSkull;
import net.ilexiconn.jurassicraft.common.item.ItemTooth;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileDNAExtractor
extends TileEntity
implements ISidedInventory {
    private static final short extractionSpeed = 100;
    private ItemStack[] slots = new ItemStack[8];
    private short extractionTime = 0;
    private ArrayList<ItemDNA> allDNAs = new ArrayList();

    public TileDNAExtractor() {
        for (Creature creature : CreatureHandler.getCreatures()) {
            ItemDNA dna = creature.getDNA();
            if (dna == null) continue;
            this.allDNAs.add(dna);
        }
    }

    public short getExtractionTime() {
        return this.extractionTime;
    }

    public void setExtractionTime(short time) {
        this.extractionTime = time;
    }

    public short getExtractionSpeed() {
        return 100;
    }

    public int getExtractionProgressScaled(int i) {
        return this.getExtractionTime() * i / this.getExtractionSpeed();
    }

    public boolean isExtracting() {
        return this.getExtractionTime() > 0;
    }

    private boolean canExtract() {
        if (this.slots[0] == null && this.slots[1] == null && this.slots[2] == null && this.slots[3] == null) {
            return false;
        }
        return this.slots[4] == null || this.slots[5] == null || this.slots[6] == null || this.slots[7] == null;
    }

    private void extractItem() {
        for (int i = 0; i < 4; ++i) {
            int j;
            if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof IDNASource)) continue;
            ItemStack newItem = null;
            if (this.slots[i].func_77973_b() instanceof ItemFossil) {
                newItem = this.getDNASampleFromFossil();
            } else if (this.slots[i].func_77973_b() instanceof ItemMeat) {
                newItem = this.getDNASampleFromMeat(this.slots[i]);
            } else if (this.slots[i].func_77973_b() instanceof ItemAmber) {
                newItem = this.getDNASampleFromAmber();
            } else if (this.slots[i].func_77973_b() instanceof ItemFur || this.slots[i].func_77973_b() instanceof ItemSkin || this.slots[i].func_77973_b() instanceof ItemScale || this.slots[i].func_77973_b() instanceof ItemFeather || this.slots[i].func_77973_b() instanceof ItemSkull || this.slots[i].func_77973_b() instanceof ItemTooth || this.slots[i].func_77973_b() instanceof ItemBristles) {
                newItem = this.getDNASampleFromDrop(this.slots[i]);
            } else {
                int output = this.field_145850_b.field_73012_v.nextInt(3);
                if (output == 0) {
                    newItem = new ItemStack((Block)Blocks.field_150354_m, 1 + this.field_145850_b.field_73012_v.nextInt(2));
                } else if (output == 1) {
                    newItem = new ItemStack(Blocks.field_150347_e, 1 + this.field_145850_b.field_73012_v.nextInt(2));
                } else if (output == 2) {
                    newItem = new ItemStack(Items.field_151103_aS, 1 + this.field_145850_b.field_73012_v.nextInt(3));
                }
            }
            if (newItem == null) continue;
            for (j = 4; j < 8; ++j) {
                if (this.slots[j] == null || this.slots[j].func_77973_b() != newItem.func_77973_b() || newItem.func_77942_o()) continue;
                --this.slots[i].field_77994_a;
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = null;
                }
                ++this.slots[j].field_77994_a;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            for (j = 4; j < 8; ++j) {
                if (this.slots[j] != null) continue;
                --this.slots[i].field_77994_a;
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = null;
                }
                this.slots[j] = newItem;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
        }
    }

    private ItemStack getDNASampleFromFossil() {
        if (this.field_145850_b.field_73012_v.nextFloat() >= 0.7f) {
            ItemStack dna = new ItemStack(this.getRandomDNA());
            if (!dna.func_77942_o()) {
                NBTTagCompound compound = new NBTTagCompound();
                float probability = this.field_145850_b.field_73012_v.nextFloat();
                if (probability <= 0.1f) {
                    compound.func_74768_a("Quality", 100);
                } else if (probability <= 0.35f) {
                    compound.func_74768_a("Quality", 75);
                } else if (probability <= 0.75f) {
                    compound.func_74768_a("Quality", 50);
                } else {
                    compound.func_74768_a("Quality", 25);
                }
                compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
                dna.func_77982_d(compound);
                return dna;
            }
            if (!dna.func_77978_p().func_74764_b("Quality")) {
                float probability = this.field_145850_b.field_73012_v.nextFloat();
                if (probability <= 0.1f) {
                    dna.func_77978_p().func_74768_a("Quality", 100);
                } else if (probability <= 0.35f) {
                    dna.func_77978_p().func_74768_a("Quality", 75);
                } else if (probability <= 0.75f) {
                    dna.func_77978_p().func_74768_a("Quality", 50);
                } else {
                    dna.func_77978_p().func_74768_a("Quality", 25);
                }
            }
            if (!dna.func_77978_p().func_74764_b("DNA")) {
                dna.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            }
        } else {
            int output = this.field_145850_b.field_73012_v.nextInt(3);
            if (output == 0) {
                return new ItemStack((Block)Blocks.field_150354_m, 1 + this.field_145850_b.field_73012_v.nextInt(2));
            }
            if (output == 1) {
                return new ItemStack(Blocks.field_150347_e, 1 + this.field_145850_b.field_73012_v.nextInt(2));
            }
            if (output == 2) {
                return new ItemStack(Items.field_151103_aS, 1 + this.field_145850_b.field_73012_v.nextInt(3));
            }
        }
        return null;
    }

    private ItemStack getDNASampleFromAmber() {
        ItemStack dna = new ItemStack(this.getRandomDNA());
        if (!dna.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Quality", 100);
            compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            dna.func_77982_d(compound);
            return dna;
        }
        if (!dna.func_77978_p().func_74764_b("Quality")) {
            dna.func_77978_p().func_74768_a("Quality", 100);
        }
        if (!dna.func_77978_p().func_74764_b("DNA")) {
            dna.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
        }
        return dna;
    }

    private ItemStack getDNASampleFromMeat(ItemStack meat) {
        ItemStack dna = new ItemStack(this.getDNAFromMeat((ItemMeat)meat.func_77973_b()));
        if (meat.func_77942_o()) {
            dna.func_77982_d(meat.func_77978_p());
            if (!dna.func_77978_p().func_74764_b("Quality")) {
                dna.func_77978_p().func_74768_a("Quality", 100);
            }
            if (!dna.func_77978_p().func_74764_b("DNA")) {
                dna.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            }
            return dna;
        }
        if (!dna.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Quality", 100);
            compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            dna.func_77982_d(compound);
            return dna;
        }
        if (!dna.func_77978_p().func_74764_b("Quality")) {
            dna.func_77978_p().func_74768_a("Quality", 100);
        }
        if (!dna.func_77978_p().func_74764_b("DNA")) {
            dna.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
        }
        return dna;
    }

    private ItemStack getDNASampleFromDrop(ItemStack stack) {
        ItemStack dna = null;
        Item item = stack.func_77973_b();
        dna = item instanceof ItemFur ? new ItemStack((Item)((ItemFur)item).getCorrespondingDNA()) : (item instanceof ItemSkin ? new ItemStack((Item)((ItemSkin)item).getCorrespondingDNA()) : (item instanceof ItemScale ? new ItemStack((Item)((ItemScale)item).getCorrespondingDNA()) : (item instanceof ItemFeather ? new ItemStack((Item)((ItemFeather)item).getCorrespondingDNA()) : (item instanceof ItemSkull ? new ItemStack((Item)((ItemSkull)item).getCorrespondingDNA()) : (item instanceof ItemTooth ? new ItemStack((Item)((ItemTooth)item).getCorrespondingDNA()) : (item instanceof ItemBristles ? new ItemStack((Item)((ItemBristles)item).getCorrespondingDNA()) : new ItemStack(this.getRandomDNA())))))));
        if (stack.func_77942_o()) {
            dna.func_77982_d(stack.func_77978_p());
            if (!dna.func_77978_p().func_74764_b("Quality")) {
                dna.func_77978_p().func_74768_a("Quality", 100);
            }
            if (!dna.func_77978_p().func_74764_b("DNA")) {
                dna.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            }
            return dna;
        }
        if (!dna.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("Quality", 100);
            compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            dna.func_77982_d(compound);
            return dna;
        }
        if (!dna.func_77978_p().func_74764_b("Quality")) {
            dna.func_77978_p().func_74768_a("Quality", 100);
        }
        if (!dna.func_77978_p().func_74764_b("DNA")) {
            dna.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
        }
        return dna;
    }

    private Item getDNAFromMeat(ItemMeat meat) {
        return meat.getCorrespondingDNA();
    }

    private Item getRandomDNA() {
        return this.allDNAs.get(this.field_145850_b.field_73012_v.nextInt(this.allDNAs.size()));
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.canExtract()) {
                this.extractionTime = (short)(this.extractionTime + 1);
                if (this.getExtractionTime() >= this.getExtractionSpeed()) {
                    this.setExtractionTime((short)0);
                    this.extractItem();
                }
            } else {
                this.setExtractionTime((short)0);
            }
        }
    }

    public boolean hasItems() {
        return this.slots[0] != null || this.slots[1] != null || this.slots[2] != null || this.slots[3] != null || this.slots[4] != null || this.slots[5] != null || this.slots[6] != null || this.slots[7] != null;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int stackSize) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= stackSize) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(stackSize);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack stack = this.slots[i];
            this.slots[i] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        this.slots[i] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "DNA Extractor";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            byte slot = compound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.setExtractionTime(nbt.func_74765_d("ExtractionTime"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("ExtractionTime", this.getExtractionTime());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

